﻿namespace ShaderAssistAddons.Modules.ShaderConfig.ViewModels
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.ViewModels;

    /// <summary>
    /// ウィザードダイアログ内処理のビューモデル抽象クラスです。
    /// </summary>
    public abstract class WizardViewModel : ViewModel
    {
        private string title = string.Empty;

        /// <summary>
        /// タイトルを取得設定します。
        /// </summary>
        public string Title
        {
            get
            {
                return this.title;
            }

            set
            {
                this.SetProperty(ref this.title, value);
            }
        }

        /// <summary>
        /// ページ数を取得します。
        /// </summary>
        public int PageCount
        {
            get
            {
                return this.PageViewModels.Length;
            }
        }

        /// <summary>
        /// ページビューモデルを取得設定します。
        /// </summary>
        protected WizardPageViewModel[] PageViewModels
        {
            get;
            set;
        }

        /// <summary>
        /// ページビューモデルを取得します。
        /// </summary>
        /// <param name="no">取得するページ番号です。</param>
        /// <returns>ページビューモデルを返します。</returns>
        public WizardPageViewModel GetPageViewModel(int no)
        {
            Debug.Assert(this.PageViewModels != null);
            Debug.Assert(no >= 0 && no < this.PageCount);

            return PageViewModels[no];
        }

        /// <summary>
        /// ページを移動した際の処理です。
        /// </summary>
        /// <param name="pageNo">ページ番号です。</param>
        /// <param name="goNext">次へを押された場合には true になります。</param>
        public abstract void ProcPage(int pageNo, bool goNext);
    }
}
