﻿namespace ShaderAssistAddons.Modules.ShaderConfig.ViewModels
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using ShaderAssistAddons.Resources;

    /// <summary>
    /// マクロ設定を行うビューモデルです。
    /// </summary>
    public class MacroSettingViewModel : WizardPageViewModel
    {
        private readonly ObservableCollection<MacroViewModel> macroViewModels = new ObservableCollection<MacroViewModel>();
        private MacroViewModel selectedMacroViewModel = null;

        /// <summary>
        /// マクロビューモデルを取得します。
        /// </summary>
        public ObservableCollection<MacroViewModel> MacroViewModels
        {
            get
            {
                return this.macroViewModels;
            }
        }

        /// <summary>
        /// 選択されているマクロビューモデルを取得設定します。
        /// </summary>
        public MacroViewModel SelectedMacroViewModel
        {
            get
            {
                return selectedMacroViewModel;
            }

            set
            {
                this.SetProperty(ref this.selectedMacroViewModel, value);
            }
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="wizardViewModel">ウィザードビューモデルです。</param>
        public MacroSettingViewModel(WizardViewModel wizardViewModel)
            : base(wizardViewModel)
        {
            this.Description = ShaderConfigMessage.WizardDescriptionMacro;
        }

        /// <summary>
        /// MacroViewModel 配列を取得します。
        /// </summary>
        /// <returns>MacroViewModel を返します。</returns>
        public MacroViewModel[] GetMacroViewModels()
        {
            // 空欄部分は省きます。
            for (int idx = this.macroViewModels.Count() - 1; idx >= 0; --idx)
            {
                if (string.IsNullOrEmpty(this.macroViewModels[idx].Name))
                {
                    this.macroViewModels.Remove(this.macroViewModels[idx]);
                }
            }

            return this.macroViewModels.ToArray();
        }

        /// <summary>
        /// 次ページに進めるかを取得します。
        /// </summary>
        /// <returns>進める場合 true を返します。</returns>
        public override bool CanGoNext()
        {
            return true;
        }

        /// <summary>
        /// 前ページに進めるかを取得します。
        /// </summary>
        /// <returns>進める場合 true を返します。</returns>
        public override bool CanGoBack()
        {
            return true;
        }
    }
}
