﻿namespace ShaderAssistAddons.Modules.ShaderConfig.ViewModels
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using Opal.ViewModels;

    /// <summary>
    /// エラーメッセージ表示コントロールのビューモデルです。
    /// </summary>
    public class ErrorMessageTextBlockViewModel : ViewModel
    {
        string _message;
        Visibility _visibility;

        //---------------------------------------------------------------------

        public bool IsShown
        {
            get { return (Visibility == Visibility.Visible); }
            set { Visibility = (value ? Visibility.Visible : Visibility.Hidden); }
        }

        public string Message
        {
            get { return _message; }
            set
            {
                if (value != _message)
                {
                    _message = value;
                    this.RaisePropertyChanged("Message");
                }
            }
        }

        public Visibility Visibility
        {
            get { return _visibility; }
            protected set
            {
                if (value != _visibility)
                {
                    _visibility = value;
                    this.RaisePropertyChanged("Visibility");
                }
            }
        }

        //---------------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ErrorMessageTextBlockViewModel()
        {
            Visibility = Visibility.Hidden;
        }
    }
}
