﻿namespace ShaderAssistAddons.Menus
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using G3dCore.Resources;
    using G3dCore.ViewModels;
    using Opal.App;
    using Opal.Menus;
    using Opal.Plugins;
    using ShaderAssistAddons.Properties;

    /// <summary>
    /// ファイル保存メニュークラスです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public sealed class SaveFileMenu : CommandableMenuPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public SaveFileMenu()
            : base("SaveFile", Labels.SaveFsc, 0)
        {
            this.SetCommand(param => this.DoCommand(param), param => { return this.CanDoCommand(param); });
        }

        /// <summary>
        /// メニュー内のどの種類かを取得します。
        /// </summary>
        public override MenuCategory Category
        {
            get
            {
                return MenuCategory.FileSave;
            }
        }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        private void DoCommand(object parameter)
        {
            AppManager.WriteDebug("SaveFileMenu");

            var activeDocument = AppManager.GetActiveDocument() as G3dDocumentViewModel;
            if (activeDocument == null)
            {
                return;
            }

            var file = activeDocument.FileViewModel;
            file.SaveDocument(file.FilePath);
        }

        /// <summary>
        /// コマンドが実行可能か判定します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        /// <returns>実行可能な場合は、true を返します。</returns>
        private bool CanDoCommand(object parameter)
        {
            return AppManager.GetActiveDocument() as G3dDocumentViewModel != null;
        }
    }
}
