﻿namespace G3dAddons.Menus
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using G3dAddons.Properties;
    using Opal.App;
    using Opal.Logs;
    using Opal.Menus;
    using Opal.Plugins;

    /// <summary>
    /// ログ出力の負荷テスト用メニュークラスです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public sealed class OutputStressTestMenu : CommandableMenuPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OutputStressTestMenu()
            : base("OutputStressTest", Resources.OutputStressTest, 2)
        {
            this.SetCommand(param => this.DoCommand(param), param => { return this.CanDoCommand(param); });
        }

        /// <summary>
        /// メニュー内のどの種類かを取得します。
        /// </summary>
        public override MenuCategory Category
        {
            get
            {
                 return MenuCategory.FileNew;
            }
        }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        private void DoCommand(object parameter)
        {
            var logManager = AppManager.GetLogManager();
            Debug.Assert(logManager != null);

            for (int i = 0; i < 1000000; ++i)
            {
                var logger = new Logger();
                logger.Debug("OutputStressTest");
                logManager.PushLogger(logger);
                logManager.FlushAll();
            }
        }

        /// <summary>
        /// コマンドが実行可能か判定します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        /// <returns>実行可能な場合は、true を返します。</returns>
        private bool CanDoCommand(object parameter)
        {
            return true;
        }
    }
}
