﻿namespace G3dAddons.Menus
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using G3dAddons.Properties;
    using G3dCore.Storages;
    using G3dCore.Resources;
    using Microsoft.Win32;
    using Opal.App;
    using Opal.Menus;
    using Opal.Plugins;

    /// <summary>
    /// ファイル開くメニュークラスです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public sealed class OpenFileMenu : CommandableMenuPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OpenFileMenu()
            : base("OpenFile", Labels.MenuOpenIf, 0)
        {
            this.SetCommand(param => this.DoCommand(param), param => { return this.CanDoCommand(param); });
        }

        /// <summary>
        /// メニュー内のどの種類かを取得します。
        /// </summary>
        public override MenuCategory Category
        {
            get
            {
                return MenuCategory.FileOpen;
            }
        }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        private void DoCommand(object parameter)
        {
            AppManager.WriteDebug("OpenFileMenu");
        }

        /// <summary>
        /// コマンドが実行可能か判定します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        /// <returns>実行可能な場合は、true を返します。</returns>
        private bool CanDoCommand(object parameter)
        {
            return false;
        }
    }
}
