﻿namespace ChalkboardAddons.Windows
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using ChalkboardCore.Modules.About;
    using Opal.Plugins;
    using Opal.Windows;
    using Opal.Windows.Generic;

    /// <summary>
    /// バージョン情報ウィンドウ作成クラスです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public sealed class AboutWindowMaker : WindowMakerPlugin<WindowArgs>
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public AboutWindowMaker()
            : base(typeof(AboutWindow))
        {
        }

        /// <summary>
        /// ウィンドウを作成します。
        /// </summary>
        /// <param name="args">ウィンドウ表示の引数クラスです。</param>
        /// <returns>ウィンドウのインスタンスを返します。</returns>
        protected override Window CreateWindow(WindowArgs args)
        {
            return new AboutWindow();
        }
    }
}
