﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

namespace UserConfig
{
    [Serializable]
    [XmlType("UserConfig.IO")]
    public class IO
    {
        [XmlAttribute]
        public bool AutoFix;

        [XmlAttribute]
        public bool AutoFixLightAnimation;

        [XmlAttribute]
        public bool AutoReloadUpdatedOnLoad;

        [XmlAttribute]
        public bool DumpShaderSource;

        [XmlAttribute]
        public int MaximumRecentlyUsedFileCount;

        [XmlAttribute]
        public int MaximumRecentlyUsedProjectCount;

        public IO()
        {
            // 初期値
            AutoFix	= false;
            AutoFixLightAnimation = false;
            AutoReloadUpdatedOnLoad = false;
            DumpShaderSource = false;
            MaximumRecentlyUsedFileCount = 10;
            MaximumRecentlyUsedProjectCount = 10;
        }
    }
}
