﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Viewer
{
    /// <summary>編集ターゲットのオブジェクトタイプ</summary>
    public enum EditTargetType
    {
        /// <summary>マテリアルターゲット</summary>
        Material = 0x01,

        /// <summary>モデルターゲット</summary>
        Model = 0x02,

        /// <summary>テクスチャターゲット</summary>
        Texture = 0x03,

        /// <summary>シェイプ</summary>
        Shape = 0x04,

        /// <summary>ボーン</summary>
        Bone = 0x05,

        /// <summary>カメラアニメーション</summary>
        CameraAnim = 0x06,

        /// <summary>ライトアニメーション</summary>
        LightAnim = 0x07,

        /// <summary>フォグアニメーション</summary>
        FogAnim = 0x08,

        /// <summary>マスク</summary>
        Mask = 0xFF,

    }

    /// <summary>メッセージカテゴリ</summary>
    public enum MessageCategory
    {
        /// <summary>ファイル</summary>
        File = 0x0000,
        /// <summary>オブジェクト</summary>
        System = 0x0001,
        /// <summary>マテリアル</summary>
        Material = 0x0002,
        /// <summary>モデル</summary>
        Model = 0x0003,
        /// <summary>メッシュ</summary>
        Shader = 0x0004,
        /// <summary>メッシュ</summary>
        Shape = 0x0005,
        /// <summary>ボーン</summary>
        Bone = 0x0006,
        /// <summary>アニメーション</summary>
        Animation = 0x0007,
    }

}
