﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using App.Controls;

namespace Viewer
{
    public sealed partial class OnAttachCommandReceivedDialog_Modified : OkDialog
    {
        public enum Mode
        {
            ModifiedModel,	// 変更済みの既存モデルをアタッチ
            ReloadedModel,	// モデルを開き直してアタッチ
            Cancel			// アタッチをキャンセル
        }

        public Mode AttachMode{ get; private set; }

        public OnAttachCommandReceivedDialog_Modified(string modelName)
        {
            InitializeComponent();

            AttachMode = Mode.Cancel;

            lblMessage.Text = string.Format(lblMessage.Text, modelName);

            rbnModifiedModel.Tag	= Mode.ModifiedModel;
            rbnReloadModel.Tag		= Mode.ReloadedModel;
            rbnCancel.Tag			= Mode.Cancel;

            rbnModifiedModel.SetCheckedByTag(AttachMode);
            rbnReloadModel.SetCheckedByTag(AttachMode);
            rbnCancel.SetCheckedByTag(AttachMode);
        }

        private void Mode_RadioChecked(object sender, EventArgs e)
        {
            AttachMode = (Mode)(sender as Control).Tag;
        }

        private void OnAttachCommandReceivedDialog_Modified_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (DialogResult != DialogResult.OK)
            {
                AttachMode = Mode.Cancel;
            }
        }
    }
}
