﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using App.res;
using nw.g3d.nw4f_3dif;

namespace App.Data
{
    /// <summary>
    /// ＵＩテキストクラス。
    /// </summary>
    public static partial class UIText
    {
        #region フラグ
        /// <summary>
        /// フラグ（On/Off）。
        /// </summary>
        public static string FlagOnOff(bool flag)
        {
            return flag ? Strings.Flag_On : Strings.Flag_Off;
        }

        /// <summary>
        /// フラグ（はい/いいえ）。
        /// </summary>
        public static string FlagYesNo(bool flag)
        {
            return flag ? Strings.Flag_Yes : Strings.Flag_No;
        }

        /// <summary>
        /// フラグ（有効/無効）。
        /// </summary>
        public static string FlagEnableDisable(bool flag)
        {
            return flag ? Strings.Flag_Enable : Strings.Flag_Disable;
        }

        /// <summary>
        /// フラグ（あり/なし）。
        /// </summary>
        public static string FlagExistOrNot(bool flag)
        {
            return flag ? Strings.Flag_Exist : Strings.Flag_NotExist;
        }

        /// <summary>
        /// フラグ（使用する/使用しない）。
        /// </summary>
        public static string FlagUseOrNot(bool flag)
        {
            return flag ? Strings.Flag_Use : Strings.Flag_NotUse;
        }

        /// <summary>
        /// フラグ（表示/非表示）。
        /// </summary>
        public static string FlagVisibleOrNonvisible(bool flag)
        {
            return flag ? Strings.Flag_Visible : Strings.Flag_NonVisible;
        }
        #endregion

        #region float配列
        public static string Float3Label(float[] vector, bool isRotate, string format = "F3")
        {
            float x = isRotate ? (float)(180 * vector[0] / Math.PI) : vector[0];
            float y = isRotate ? (float)(180 * vector[1] / Math.PI) : vector[1];
            float z = isRotate ? (float)(180 * vector[2] / Math.PI) : vector[2];

            return
                string.Format("({0}, {1}, {2})",
                    x.ToString(format),
                    y.ToString(format),
                    z.ToString(format)
                );
        }

        public static string Float4Label(float[] vector, bool isRotate, string format = "F4")
        {
            float x = isRotate ? (float)(180 * vector[0] / Math.PI) : vector[0];
            float y = isRotate ? (float)(180 * vector[1] / Math.PI) : vector[1];
            float z = isRotate ? (float)(180 * vector[2] / Math.PI) : vector[2];
            float w = isRotate ? (float)(180 * vector[3] / Math.PI) : vector[3];

            return
                string.Format("({0}, {1}, {2}, {3})",
                    x.ToString(format),
                    y.ToString(format),
                    z.ToString(format),
                    w.ToString(format)
                );
        }
        #endregion

        #region 16進表示
        public static string UintX(uint v)
        {
            return "0x"+v.ToString("X8");
        }
        #endregion


        #region MipLevel
        /// <summary>
        /// ミップマップレベルの表示
        /// </summary>
        public static string MipLevel(int level)
        {
            return level > 1 ? level.ToString() : Strings.Texture_MipmapNone;
        }
        #endregion

        #region MipmapMinSize
        /// <summary>
        /// ミップマップ最小サイズ
        /// </summary>
        public static string MipmapMinSize(texture_infoType info)
        {
            int width = Math.Max(info.width >> (info.mip_level - 1), 1);
            int height = Math.Max(info.height >> (info.mip_level - 1), 1);
            return info.mip_level > 1 ? string.Format("{0} x {1}", width, height) : string.Empty;
        }
        #endregion

        #region ComponentSelector
        public static string ComponentSelector(texture_info_comp_selValue[] src)
        {
            string str = string.Empty;
            {
                foreach(var s in src)
                {
                    switch(s)
                    {
                        case texture_info_comp_selValue.r:		str += "R ";	break;
                        case texture_info_comp_selValue.g:		str += "G ";	break;
                        case texture_info_comp_selValue.b:		str += "B ";	break;
                        case texture_info_comp_selValue.a:		str += "A ";	break;
                        case texture_info_comp_selValue.Item0:	str += "0 ";	break;
                        case texture_info_comp_selValue.Item1:	str += "1 ";	break;
                        default:	Debug.Assert(false);						break;
                    }
                }
            }
            return str;
        }
        #endregion

        #region モード
        public static string TextureSrtMode(float mode)
        {
            if (mode == 0)
            {
                return "Maya";
            }

            if (mode == 1)
            {
                return "3ds Max";
            }

            if (mode == 2)
            {
                return "Softimage";
            }

            Debug.Assert(false);
            return mode.ToString();
        }
        #endregion
    }
}
