﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace App.Utility
{
    public static class TreeUtility
    {
        // pre-order で木を走査
        public static IEnumerable<T> PreOrder<T>(T root, Func<T, IEnumerable<T>> children)
        {
            return Enumerable.Repeat(root, 1).Concat(children(root).SelectMany(x => PreOrder(x, children)));
        }

        // post-order で木を走査
        public static IEnumerable<T> PostOrder<T>(T root, Func<T, IEnumerable<T>> children)
        {
            return children(root).SelectMany(x => PostOrder(x, children)).Concat(Enumerable.Repeat(root, 1));
        }

        public static Func<T, S> PreOrderDP<T, S>(Func<T, S> f, Func<T, IEnumerable<T>> children, Func<IEnumerable<S>, S> combine)
        {
            var table = new Dictionary<T, S>();
            Func<T, S> func = null;
            func = x =>
            {
                S v;
                if (table.TryGetValue(x, out v))
                {
                    return v;
                }

                v = combine(Enumerable.Repeat(f(x), 1).Concat(children(x).Select(func)));

                table[x] = v;

                return v;
            };

            return func;
        }

        public static Func<T, IEnumerable<S>> Revert<T, S>(Func<S, IEnumerable<T>> parent, IEnumerable<S> items)
        {
            var children = new Dictionary<T, List<S>>();
            foreach (var item in items)
            {
                foreach (var p in parent(item))
                {
                    List<S> list;
                    if (!children.TryGetValue(p, out list))
                    {
                        list = new List<S>();
                    }
                    list.Add(item);
                }
            }

            return x =>
            {
                List<S> list;
                if (children.TryGetValue(x, out list))
                {
                    return list;
                }
                else
                {
                    return Enumerable.Empty<S>();
                }
            };
        }
    }
}
