﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace App.Utility
{
    public sealed class HighQualityGraphics : IDisposable
    {
        private readonly Graphics			graphics_;

        private readonly InterpolationMode	oldInterpolationMode_;
        private readonly SmoothingMode		oldSmoothingMode_;
        private readonly bool				isInterpolationMode_;
        private readonly bool				isSmoothingMode_;

        public HighQualityGraphics(Graphics graphics, bool isInterpolationMode = true, bool isSmoothingMode = true)
        {
            graphics_				= graphics;
            isInterpolationMode_	= isInterpolationMode;
            isSmoothingMode_		= isSmoothingMode;

            if (isInterpolationMode_)
            {
                oldInterpolationMode_		= graphics_.InterpolationMode;
                graphics_.InterpolationMode	= InterpolationMode.HighQualityBicubic;
            }

            if (isSmoothingMode_)
            {
                oldSmoothingMode_			= graphics_.SmoothingMode;
                graphics_.SmoothingMode		= SmoothingMode.HighQuality;
            }
        }

        public void Dispose()
        {
            if (isInterpolationMode_)
            {
                graphics_.InterpolationMode	= oldInterpolationMode_;
            }

            if (isSmoothingMode_)
            {
                graphics_.SmoothingMode		= oldSmoothingMode_;
            }
        }
    }
}
