﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Drawing;
using App.Data;
using App.Properties;

namespace App.Utility
{
    /// <summary>
    /// 編集カラー。
    /// </summary>
    public static class EditColorUtility
    {
        static private readonly Image[] images = new Image[]
        {
            Resources.EditColor,
            Resources.EditColor_MouseOver,
            Resources.EditColor_MouseDown
        };

        public enum MouseState
        {
            Normal,
            MouseOver,
            MouseDown,
            Disable,
        }

        public static void Draw(MouseState state, RgbaColor? color, Graphics graphics, int x, int y, int width = 16, int height = 16, float gamma = 1)
        {
            if (state == MouseState.Disable)
            {
                graphics.DrawImage(Resources.EditColorNull, x, y, width, height);
            }
            else
            if (state == MouseState.Normal && !color.HasValue)
            {
                graphics.DrawImage(Resources.EditColorNull2, x, y, width, height);
            }
            else
            {
                Color targetColor = Color.White;
                if (color.HasValue)
                {
                    RgbaColor rgbacolor = (RgbaColor)color;
                    targetColor = ColorUtility.Pow(rgbacolor.ToColor(), gamma);
                }

                using (var brush = new SolidBrush(targetColor))
                {
                    graphics.FillRectangle(brush, x + 1, y + 1, 14, 14);
                }

                graphics.DrawImage(images[(int)state], x, y, width, height);
            }
        }
    }
}
