﻿using System;
using System.Windows.Forms;
using ConfigCommon;

namespace App.Utility
{
    public static class DialogUtility
    {
        /// <summary>
        /// ファイルダイアログが開いているかどうか
        /// </summary>
        public static bool IsOpened { get; private set; }


        public static bool ExecuteOpenFileDialog(out string[] fileNames, bool multiselect = true, string title = null)
        {
            using(OpenFileDialog dialog = CreateDialog(ObjectIDUtility.FileFilterAll(), multiselect, title))
            {
                IsOpened = true;
                if (dialog.ShowDialog(TheApp.MainFrame) == DialogResult.OK)
                {
                    fileNames = dialog.FileNames;
                    IsOpened = false;
                    return true;
                }
            }

            fileNames = new string[]{};
            IsOpened = false;
            return false;
        }

        public static bool ExecuteOpenProjectDialog(out string[] fileNames, string title = null)
        {
            using (OpenFileDialog dialog = CreateDialog(ObjectIDUtility.FileFilterProject(), false, title))
            {
                IsOpened = true;
                if (dialog.ShowDialog(TheApp.MainFrame) == DialogResult.OK)
                {
                    fileNames = dialog.FileNames;
                    IsOpened = false;
                    return true;
                }
            }

            fileNames = new string[]{};
            IsOpened = false;
            return false;
        }

        public static bool ExecuteOpenFileDialog(out string[] fileNames, GuiObjectID id, bool multiselect = true, string title = null)
        {
            using(OpenFileDialog dialog = CreateDialog(ObjectIDUtility.FileFilter(id), multiselect, title))
            {
                IsOpened = true;
                if (dialog.ShowDialog(TheApp.MainFrame) == DialogResult.OK)
                {
                    fileNames = dialog.FileNames;
                    IsOpened = false;
                    return true;
                }
            }

            fileNames = new string[]{};
            IsOpened = false;
            return false;
        }

        public static bool ExecuteOpenFileDialog(out string[] fileNames, string filter, bool multiselect = true, string title = null)
        {
            using (OpenFileDialog dialog = CreateDialog(filter, multiselect, title))
            {
                IsOpened = true;
                if (dialog.ShowDialog(TheApp.MainFrame) == DialogResult.OK)
                {
                    fileNames = dialog.FileNames;
                    IsOpened = false;
                    return true;
                }
            }

            fileNames = new string[] { };
            IsOpened = false;
            return false;
        }

        /// <summary>
        /// ダイアログの作成。
        /// </summary>
        private static OpenFileDialog CreateDialog(string filter, bool multiselect, string title)
        {
            OpenFileDialog dialog = new OpenFileDialog()
            {
                Filter = filter,
                Multiselect = multiselect,
            };

            if (title != null)
            {
                dialog.Title = title;
            }

            return dialog;
        }

        // TODO: 削除
        /// <summary>
        /// ヘルププロバイダの初期設定
        /// </summary>
        public static void SetHelp(Control control, string helpPath)
        {
            /*
            control.HelpRequested += (s, e) =>
            {
                DebugConsole.WriteLine("control.HelpRequested : {0}, {1}", control, helpPath);

                Help.ShowHelp(new Control(), TheApp.HelpNamespace, helpPath);
            };
             */
        }

        public static void SetHelp(Control control, HelpUtility.PageKey pageKey)
        {
            control.HelpRequested += (s, e) =>
                {
                    // 選択されているプロパティからヘルプページを取得する
                    App.PropertyEdit.ObjectPropertyPanel objectPropertyPanel = control as App.PropertyEdit.ObjectPropertyPanel;
                    if (objectPropertyPanel != null)
                    {
                        pageKey = objectPropertyPanel.Owner.HelpPageKey;
                    }

                    DebugConsole.WriteLine("control.HelpRequested : {0}, {1}", control, pageKey);
                    HelpUtility.Open(pageKey);
                };
        }

        // F1押下をシュミレートする
        public static void EmulatePushF1()
        {
            // key down
            Win32.NativeMethods.keybd_event((byte)Win32.VK.VK_F1, 0, 0, (UIntPtr)0);

            // key up
            Win32.NativeMethods.keybd_event((byte)Win32.VK.VK_F1, 0, Win32.NativeMethods.KEYEVENTF_KEYUP, (UIntPtr)0);
        }

        public static void BeginInvokeOrExecute(this Control control, Action action)
        {
            if (control.IsHandleCreated)
            {
                control.BeginInvoke(action);
            }
            else
            {
                action();
            }
        }
    }
}
