﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace App.Utility
{
    /// <summary>
    /// データサイズクラス。
    /// </summary>
    public static class DataSize
    {
        /// <summary>
        /// キロバイト数。
        /// </summary>
        public static float KBytes(int bytes)
        {
            return bytes / 1024.0f;
        }

        /// <summary>
        /// キロバイト数テキスト。
        /// </summary>
        public static string KBytesText(int bytes)
        {
            float kb = KBytes(bytes);
            return string.Format("{0:f2} KB", kb);
        }

        /// <summary>
        /// メガバイト数。
        /// </summary>
        public static float MBytes(int bytes)
        {
            return bytes / 1024.0f / 1024.0f;
        }

        /// <summary>
        /// メガバイト数テキスト。
        /// </summary>
        public static string MBytesText(int bytes)
        {
            float mb = MBytes(bytes);
            return string.Format("{0:f2} MB", mb);
        }

        public static string XBytesText(int bytes)
        {
            return (bytes >= 1024*1024) ? MBytesText(bytes) : KBytesText(bytes);
        }
    }
}
