﻿using App.Data;
using App.res;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class ShapeAnimationPropertyPanel : AnimationObjectPropertyPanel
    {
        private PropertyCategoryNode ctgGeneral;
        private PropertyCategoryNode ctgCurve;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ShapeAnimationPropertyPanel()
        {
            InitializeCategoryView();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
            ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_ShapeAnimation_General, PropertyPageID.ShapeAnimationGeneral, ShapeAnimationGeneralPage.CreateInstance,
                updateModifiedFunc: () => ShapeAnimationGeneralPage.IsModified(ActiveTarget));
            ctgCurve = RegisterCategory(1, Strings.ObjectPropertyPanel_ShapeAnimation_CurveEdit, PropertyPageID.ShapeAnimationCurveEdit, ShapeAnimationCurveEditPage.CreateInstance,
                updateModifiedFunc: () => ActiveTarget?.IsCurvesModified() == true);
            var ctgRoot = RegisterCategory(0, Strings.ObjectPropertyPanel_ShapeAnimation_Root, PropertyPageID.ShapeAnimationRoot, ShapeAnimationRootPage.CreateInstance);
            var ctgFileInfo = RegisterCategory(1, Strings.ObjectPropertyPanel_FileInformation, PropertyPageID.FileInformation, FileInformationPage.CreateInstance,
                updateModifiedFunc: () => FileInformationPage.IsModified(ActiveTarget));
            var ctgOptLog = RegisterCategory(1, Strings.ObjectPropertyPanel_OptimizationLog, PropertyPageID.OptimizationLog, OptimizationLogPage.CreateInstance);
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData, PropertyPageID.UserData, UserDataPage.CreateInstance,
                updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgCurve);
                ctgRoot.Nodes.Add(ctgFileInfo);
                ctgRoot.Nodes.Add(ctgOptLog);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private ShapeAnimation ActiveTarget
        {
            get { return (ShapeAnimation)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            CategoryView.SelectedNode = ctgCurve;
        }
    }
}
