﻿using System;
using App.Data;
using App.res;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class ModelPropertyPanel : ObjectPropertyPanel
    {
        private PropertyCategoryNode ctgGeneral;
        private PropertyCategoryNode ctgPreview;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ModelPropertyPanel()
        {
            InitializeCategoryView();

            Action action = () =>
                {
                    if (Targets.Active is Model)
                    {
                        Viewer.QueryModelLayoutMessage.Send(ActiveTarget);
                    }
                };
            TheApp.MainFrame.HioConnected += action;
            Disposed += (s, e) =>
            {
                TheApp.MainFrame.HioConnected -= action;
            };
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_model_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
            var ctgRoot     = RegisterCategory(0, Strings.ObjectPropertyPanel_Model_Root,		PropertyPageID.ModelRoot,		ModelRootPage.CreateInstance);
            ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_Model_General, PropertyPageID.ModelGeneral, ModelGeneralPage.CreateInstance,
                updateModifiedFunc: () => ModelGeneralPage.IsModified(ActiveTarget));
            ctgPreview  = RegisterCategory(4, Strings.ObjectPropertyPanel_Model_Preview,	PropertyPageID.ModelPreview,	ModelPreviewPage.CreateInstance,
                updateModifiedFunc: () => ModelPreviewPage.IsModified(ActiveTarget));
            var ctgLod      = RegisterCategory(1, Strings.ObjectPropertyPanel_Model_Lod,       PropertyPageID.ModelLod,        ModelLodPage.CreateInstance);
            var ctgFileInfo = RegisterCategory(1, Strings.ObjectPropertyPanel_FileInformation,	PropertyPageID.FileInformation,	FileInformationPage.CreateInstance,
                    updateModifiedFunc: () => FileInformationPage.IsModified(ActiveTarget));
            var ctgSearchPath = RegisterCategory(1, Strings.ObjectPropertyPanel_Model_SearchPath, PropertyPageID.ModelSearchPath, SearchPathPage.CreateInstance,
                    updateModifiedFunc: () => SearchPathPage.IsModified(ActiveTarget));
            var ctgOptLog = RegisterCategory(1, Strings.ObjectPropertyPanel_OptimizationLog, PropertyPageID.OptimizationLog, OptimizationLogPage.CreateInstance);
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData,        PropertyPageID.UserData,        UserDataPage.CreateInstance,
                    updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgPreview);
                ctgRoot.Nodes.Add(ctgLod);
                ctgRoot.Nodes.Add(ctgFileInfo);
                ctgRoot.Nodes.Add(ctgSearchPath);
                ctgRoot.Nodes.Add(ctgOptLog);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private Model ActiveTarget
        {
            get { return (Model)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            CategoryView.SelectedNode = ctgPreview;
        }
    }
}
