﻿using System.Collections.Generic;
using System.Linq;
using App.Data;
using App.res;
using ConfigCommon;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class LightAnimationPanel : AnimationObjectPropertyPanel
    {
        private PropertyCategoryNode ctgGeneral;
        private PropertyCategoryNode ctgCurveEdit;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public LightAnimationPanel()
        {
            InitializeCategoryView();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
            var ctgRoot = RegisterCategory(0, Strings.ObjectPropertyPanel_LightAnimation_Root, PropertyPageID.LightAnimationRoot, LightAnimationRootPage.CreateInstance);
                ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_LightAnimation_General, PropertyPageID.LightAnimationGeneral, LightAnimationGeneralPage.CreateInstance,
                    updateModifiedFunc: () => LightAnimationGeneralPage.IsModified(ActiveTarget));
                ctgCurveEdit = RegisterCategory(1, Strings.ObjectPropertyPanel_LightAnimation_CurveEdit, PropertyPageID.LightAnimationCurveEdit, LightAnimationCurveEditPage.CreateInstance,
                    updateModifiedFunc: () => ActiveTarget?.IsCurvesModified() == true);
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData, PropertyPageID.UserData, UserDataPage.CreateInstance,
                    updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgCurveEdit);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private LightAnimation ActiveTarget
        {
            get { return (LightAnimation)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            if (ActiveTarget != null)
            {
                float baseValue;
                if (ActiveTarget.LightAnimTargets.Any(x => x != null && x.KeyFrames.Any() && !x.KeyFrames.IsConstantCurve(out baseValue)))
                {
                    CategoryView.SelectedNode = ctgCurveEdit;
                    return;
                }
            }
            CategoryView.SelectedNode = ctgGeneral;
        }

        protected override void Event_Document_PropertyChanged(object sender, IEnumerable<DocumentPropertyChangedArgs> e)
        {
            if (e.Any(x => x is SceneAnimationContentArg))
            {
                foreach (var target in Targets.GetObjects(GuiObjectID.LightAnimation).OfType<LightAnimation>().ToArray())
                {
                    if (!target.Owner.LightAnims.Contains(target))
                    {
                        Targets.Remove(target);
                    }
                }
                if (Targets.IsEmpty)
                {
                    Owner.Close();
                    return;
                }
            }
            base.Event_Document_PropertyChanged(sender, e);
        }
    }
}
