﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using App.Controls;
using App.Data;
using App.res;

namespace App.PropertyEdit
{
    public partial class MaterialVisibilityAnimationMaterialSelectDialog : OkCancelDialog
    {
        public string MaterialName
        {
            get { return cmbMaterialName.Text; }
        }

        private readonly MaterialVisibilityAnimation materialVisibilityAnimation_;

        public MaterialVisibilityAnimationMaterialSelectDialog(MaterialVisibilityAnimation MaterialVisibilityAnimation)
        {
            InitializeComponent();

            materialVisibilityAnimation_ = MaterialVisibilityAnimation;

            cmbMaterialName.Items.AddRange(ParentModelMaterialNames.ToArray());
        }

        private IEnumerable<string> ParentModelMaterialNames
        {
            get
            {
                return
                    from model in DocumentManager.Models
                    from anim in model.AllAnimations
                    where anim == materialVisibilityAnimation_
                    from material in model.Materials
                    select material.Data.name;
            }
        }

        private void MaterialVisibilityAnimationMaterialSelectDialog_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (DialogResult == DialogResult.OK)
            {
                // 空文字列でないか
                {
                    if (MaterialName == string.Empty)
                    {
                        UIMessageBox.Warning(Strings.MaterialSelectDialog_EmptyName);
                        e.Cancel = true;
                        return;
                    }
                }

                // 使えない文字が入っていないか
                {
                    if (Material.IsValidateNameString(MaterialName) == false)
                    {
                        UIMessageBox.Warning(Strings.MaterialSelectDialog_InvalidateCharacter);
                        e.Cancel = true;
                        return;
                    }
                }

                // 重複チェック
                {
                    var isExist =
                        (from MaterialVisibilityMatAnim in materialVisibilityAnimation_.MaterialVisibilityMatAnims
                         where MaterialVisibilityMatAnim.mat_name == cmbMaterialName.Text
                         select MaterialVisibilityMatAnim).FirstOrDefault() != null;

                    if (isExist)
                    {
                        UIMessageBox.Warning(Strings.MaterialSelectDialog_AlreadyExistMaterial);
                        e.Cancel = true;
                        return;
                    }
                }
            }
        }
    }
}
