﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using App.Controls;
using App.Data;
using App.res;

namespace App.PropertyEdit
{
    public partial class BoneVisibilityAnimationBoneSelectDialog : OkCancelDialog
    {
        public string BoneName
        {
            get { return cmbBoneName.Text; }
        }

        public string ParentBoneName
        {
            get
            {
                Bone bone = cmbBoneName.SelectedItemData as Bone;

                return
                    ((bone == null) || (bone.Parent == null)) ?
                        string.Empty :
                        bone.Parent.Data.name;
            }
        }

        private readonly BoneVisibilityAnimation boneVisibilityAnimation_;

        public BoneVisibilityAnimationBoneSelectDialog(BoneVisibilityAnimation BoneVisibilityAnimation)
        {
            InitializeComponent();

            boneVisibilityAnimation_ = BoneVisibilityAnimation;

            using(var ub = new UpdateBlock(cmbModel))
            {
                foreach(var model in ParentModel)
                {
                    cmbModel.AddItem(model.Name, model);
                }
            }

            if (cmbModel.Items.Count > 0)
            {
                cmbModel.SelectedIndex = 0;
            }

            UpdateBoneNames();
        }

        private void UpdateBoneNames()
        {
            using(var ub = new UpdateBlock(cmbBoneName))
            {
                cmbBoneName.Items.Clear();

                Model model = cmbModel.SelectedItemData as Model;
                if (model != null)
                {
                    foreach(var bone in model.Bones)
                    {
                        cmbBoneName.AddItem(bone.Data.name, bone);
                    }
                }

                if (cmbBoneName.Items.Count > 0)
                {
                    cmbBoneName.SelectedIndex = 0;
                }
            }
        }

        private IEnumerable<Model> ParentModel
        {
            get
            {
                return
                    from model in DocumentManager.Models
                    from anim in model.AllAnimations
                    where anim == boneVisibilityAnimation_
                    select model;
            }
        }

        private void BoneVisibilityAnimationBoneSelectDialog_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (DialogResult == DialogResult.OK)
            {
                // 空文字列でないか
                {
                    if (BoneName == string.Empty)
                    {
                        UIMessageBox.Warning(Strings.MaterialSelectDialog_EmptyName);
                        e.Cancel = true;
                        return;
                    }
                }

                // 使えない文字が入っていないか
                {
                    if (Material.IsValidateNameString(BoneName) == false)
                    {
                        UIMessageBox.Warning(Strings.MaterialSelectDialog_InvalidateCharacter);
                        e.Cancel = true;
                        return;
                    }
                }

                // 重複チェック
                {
                    var isExist =
                        (from BoneVisibilityMatAnim in boneVisibilityAnimation_.BoneVisibilityBoneAnims
                         where BoneVisibilityMatAnim.bone_name == BoneName
                         select BoneVisibilityMatAnim).FirstOrDefault() != null;

                    if (isExist)
                    {
                        UIMessageBox.Warning(Strings.MaterialSelectDialog_AlreadyExistMaterial);
                        e.Cancel = true;
                        return;
                    }
                }
            }
        }

        private void cmbModel_SelectedIndexChanged(object sender, EventArgs e)
        {
            UpdateBoneNames();
        }
    }
}
