﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Linq;
using System.Windows.Forms;
using App.Data;

namespace App.PropertyEdit
{
    public partial class ShaderDefinitionSourceCodePage : ShaderDefinitionPropertyPage
    {
        public ShaderDefinitionSourceCodePage() :
            base(PropertyPageID.ShaderDefinitionSourceCode)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_shader_definition_property_window_source_code_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new ShaderDefinitionSourceCodePage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            lblForceInclude.IsModified = ActiveTarget.IsForceIncludeModified();

            var srcs = ShaderDefinition.ForceIncludeSrcs(ActiveTarget.Data).ToArray();
            lvwList.SetItemCount(srcs.Length);
            int index = 0;
            foreach (var src in srcs)
            {
                ListViewItem item = lvwList.Items[index];
                item.SubItems[clhIncludePath.Index].Text = ActiveTarget.DisplayIncludePaths[src.path];
                item.SubItems[clhPath.Index].Text = src.path;
            }
        }

        public static bool IsModified(ShaderDefinition activeTarget)
        {
            return activeTarget != null && activeTarget.IsForceIncludeModified();
        }
    }
}
