﻿using App.Command;
using App.Data;

namespace App.PropertyEdit
{
    public partial class MaterialAnimationRootPage : MaterialAnimationPropertyPage
    {
        public MaterialAnimationRootPage() :
            base(PropertyPageID.MaterialAnimationRoot)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new MaterialAnimationRootPage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            ;
        }

        #region コピー＆ペースト
        private class CopyData
        {
            public object MaterialAnimationGeneralPage{ get; set; }
            public object MaterialAnimationPatternPage { get; set; }
            public object MaterialAnimationCurveEditPage{ get; set; }
 			public object UserDataPage{ get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return true;
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(MaterialAnimation target)
        {
            return
                new CopyData()
                {
                    MaterialAnimationGeneralPage = MaterialAnimationGeneralPage.Copy(target),
                    MaterialAnimationPatternPage = MaterialAnimationPatternPage.Copy(target),
                    MaterialAnimationCurveEditPage = MaterialAnimationCurveEditPage.Copy(target),
                    UserDataPage = UserDataPage.Copy(target)
                };
        }

        /// <summary>
        /// ペーストが有効か。
        /// </summary>
        public override bool CanPaste(object copiedObjectInfo, object copiedObject)
        {
            var copyData = (CopyData)copiedObject;

            return MaterialAnimationCurveEditPage.CanPaste(copiedObjectInfo, copyData.MaterialAnimationCurveEditPage, ActiveTarget, Targets);
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            var commandSet = new EditCommandSet();
            commandSet.SetViewerDrawSuppressBlockDelegate(AnimationCurveEditCommand.AnimationMessageFilter);

            using (new Viewer.ViewerDrawSuppressBlock(AnimationCurveEditCommand.AnimationMessageFilter))
            using (new App.AppContext.PropertyChangedSuppressBlock())
            {
                var copyData = (CopyData)pasteObject;

                commandSet.Add(MaterialAnimationGeneralPage.Paste(targets, copyData.MaterialAnimationGeneralPage));
                commandSet.Add(MaterialAnimationPatternPage.Paste(targets, copyData.MaterialAnimationPatternPage));
                commandSet.Add(MaterialAnimationCurveEditPage.Paste(targets, copyData.MaterialAnimationCurveEditPage, targets.Active.ObjectID));
                commandSet.Add(UserDataPage.Paste(targets, copyData.UserDataPage));
            }

            commandSet.Reverse();
            return commandSet;
        }
        #endregion
    }
}
