﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using App.Command;
using App.Controls;
using App.Data;
using App.Utility;
using App.res;
using App.PropertyEdit.ShaderParamControls;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using System.Text.RegularExpressions;

namespace App.PropertyEdit
{
    public partial class MaterialAttribAssignPage : MaterialPropertyPage, IShaderPage
    {
        public bool UpdateControls { get; set; }
        public MaterialAttribAssignPage() :
            base(PropertyPageID.MaterialAttribAssign)
        {
            InitializeComponent();

            UpdateControls = true;

            //TheApp.MainFrame.BindHelp(this, "html/Graphics/3DEditor/html/ui/property/material/sampler.html");

            // 行の高さを変更
            //lvwList.SmallImageList = iml32Size_;
            //lvwList.LargeImageList = iml64Size_;
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new MaterialAttribAssignPage();
        }

        protected override void InitializeFormInternal()
        {
            scgGroup.ShowAttribAssign = (x, y) => true;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            if (UpdateControls)
            {
                UpdateScgGroup();
                UpdateControls = false;
            }

            scgGroup.UpdateValues(ActiveTarget);
        }

        protected void UpdateScgGroup()
        {
            var currentShaderDefinition = ActiveTarget.MaterialShaderAssign.ShaderDefinition;
            var currentProgram = ActiveTarget.MaterialShaderAssign.ShadingModel;
            Win32.User32.SendMessage(Handle, Win32.WM.WM_SETREDRAW, 0, 0);
            var currentAutoScrollPosition = AutoScrollPosition;
            this.scgGroup.UpdateControls(ActiveTarget, currentProgram);
            AutoScrollPosition = new Point(-currentAutoScrollPosition.X, -currentAutoScrollPosition.Y);
            Win32.User32.SendMessage(Handle, Win32.WM.WM_SETREDRAW, 1, 0);
            Refresh();
        }

        private void scgGroup_ValueChanged(object sender, ValueChangedEventArgs e)
        {
            if (e is SamplerValueChangedEventArgs)
            {
                scgGroup.scgGroup_ValueChanged(ActiveTarget, Targets, e as SamplerValueChangedEventArgs);
            }
            else if (e is ShaderParamValueChangedEventArgs)
            {
                scgGroup.scgGroup_ValueChanged(ActiveTarget, Targets, e as ShaderParamValueChangedEventArgs);
            }
            else if (e is OptionValueChangedEventArgs)
            {
                scgGroup.scgGroup_ValueChanged(ActiveTarget, Targets, e as OptionValueChangedEventArgs);
            }
            else if (e is AttributeValueChangedEventArgs)
            {
                scgGroup.scgGroup_ValueChanged(ActiveTarget, Targets, e as AttributeValueChangedEventArgs);
            }
            else if (e is RenderInfoValueChangedEventArgs)
            {
                scgGroup.scgGroup_ValueChanged(ActiveTarget, Targets, e as RenderInfoValueChangedEventArgs);
            }
            else
            {
                Debug.Assert(false);
            }
        }

        #region コピー＆ペースト
        public override bool CanCopy()
        {
            return scgGroup.CanCopy(ActiveTarget);
        }

        public override object Copy(ref object copyObjectInfo)
        {
            return scgGroup.Copy(ActiveTarget);
        }

        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(scgGroup.Paste(Targets, pasteObject));
        }

        public override bool CanPaste(object copiedObjectInfo, object copiedObject)
        {
            return scgGroup.CanPaste(ActiveTarget, copiedObject);
        }
        #endregion
    }
}
