﻿using App.Command;
using App.Data;

namespace App.PropertyEdit
{
    public partial class LightAnimationRootPage : LightAnimationPropertyPage
    {
        public LightAnimationRootPage() :
            base(PropertyPageID.LightAnimationRoot)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new LightAnimationRootPage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            ;
        }

        #region コピー＆ペースト
        private class CopyData
        {
            public object LightAnimationGeneralPage{ get; set; }
            public object LightAnimationCurveEditPage{ get; set; }
            public object UserDataPage { get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return true;
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(LightAnimation target)
        {
            return
                new CopyData()
                {
                    LightAnimationGeneralPage = LightAnimationGeneralPage.Copy(target),
                    LightAnimationCurveEditPage = LightAnimationCurveEditPage.Copy(target),
                    UserDataPage = UserDataPage.Copy(target),
                };
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        public override bool CanPaste(object copiedObjectInfo, object copiedObject)
        {
            return CanPaste(ActiveTarget, copiedObjectInfo, copiedObject);
        }

        public static bool CanPaste(LightAnimation activeTarget, object copiedObjectInfo, object copiedObject)
        {
            var copyData = (CopyData)copiedObject;
            return
                LightAnimationGeneralPage.CanPaste(  activeTarget, copiedObjectInfo, copyData.LightAnimationGeneralPage  ) &&
                LightAnimationCurveEditPage.CanPaste(activeTarget, copiedObjectInfo, copyData.LightAnimationCurveEditPage);
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            var commandSet = new EditCommandSet();
            {
                var copyData = (CopyData)pasteObject;

                commandSet.Add(LightAnimationCurveEditPage.Paste(targets, copyData.LightAnimationCurveEditPage));
                commandSet.Add(LightAnimationGeneralPage.Paste(targets, copyData.LightAnimationGeneralPage)); // 順番大事
                commandSet.Add(UserDataPage.Paste(targets, copyData.UserDataPage));
            }

            commandSet.Reverse();
            return commandSet;
        }
        #endregion
    }
}
