﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using App.Controls;

namespace App.ObjectView.Schematic
{
    /// <summary>
    /// オブジェクトスケマティックビューパネルクラス。
    /// </summary>
    public class ObjectSchematicViewPanel : UIPanel, IObjectView
    {
        // ビュー
        private readonly ObjectSchematicView _view = null;
        // 操作バー
        private readonly ObjectSchematicViewOpBar _opBar = null;

        public ObjectSchematicViewPanel()
        {
//			this.BorderStyle = BorderStyle.Fixed3D;
//			this.BorderStyle = BorderStyle.FixedSingle;

            // ビュー作成
            _view = new ObjectSchematicView();
            _view.Parent = this;
            _view.Dock = DockStyle.Fill;

            _opBar = new ObjectSchematicViewOpBar(_view);
            _opBar.Parent = this;
            _opBar.Dock = DockStyle.Bottom;
        }

        /// <summary>
        /// ビュー。
        /// </summary>
        public ObjectSchematicView View
        {
            get { return _view; }
        }

        /// <summary>
        /// 操作バー。
        /// </summary>
        public ObjectSchematicViewOpBar OpBar
        {
            get { return _opBar; }
        }

        /// <summary>
        /// オーバーライドイベント。
        /// </summary>
        protected override void OnGotFocus(EventArgs e)
        {
            base.OnGotFocus(e);

            // ビューにフォーカスを与える
            _view.Focus();
        }

        #region IObjectView実装
        /// <summary>
        /// インタフェース実装。
        /// </summary>
        public AppConfig.ObjectViewMode ViewMode
        {
            get { return AppConfig.ObjectViewMode.SchematicView; }
        }

        /// <summary>
        /// インタフェース実装。
        /// </summary>
        public Control Control
        {
            get { return this; }
        }

        /// <summary>
        /// インタフェース実装。
        /// </summary>
        public void FocusClient()
        {
            _view.Focus();
        }

        /// <summary>
        /// インタフェース実装。
        /// </summary>
        public bool EnableSelectAll
        {
            get { return _view.EnableSelectAll; }
        }

        /// <summary>
        /// インタフェース実装。
        /// </summary>
        public void SelectAll()
        {
            _view.SelectAll();
        }

        /// <summary>
        /// インタフェース実装。
        /// </summary>
        public bool EnableToggleSelection
        {
            get { return _view.EnableToggleSelection; }
        }

        /// <summary>
        /// インタフェース実装。
        /// </summary>
        public void ToggleSelection()
        {
            _view.ToggleSelection();
        }
        #endregion
    }
}
