﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Windows.Forms;
using App.Command;
using App.Controls;
using App.Data;
using App.Utility;

namespace App
{
    public enum MessageContext
    {
        // DocumentManager
        /// <summary>
        /// 再読み込みを行うと未保存の変更は失われます。
        /// </summary>
        IO_ReloadFromMenuModified,
        /// <summary>
        ///   &apos;{0}&apos; が他のアプリケーションにより更新されました。再読み込みしますか？
        ///再読み込みを行うと未保存の変更は失われます。
        /// </summary>
        IO_ReloadModified,
        /// <summary>
        ///   &apos;{0}&apos; が他のアプリケーションにより更新されました。再読み込みしますか？
        /// </summary>
        IO_Reload,
        /// <summary>
        ///   &apos;{0}&apos; はバインドされています。閉じてもよろしいですか？
        /// </summary>
        IO_CloseSceneAnimationBoundToAnObject,
        /// <summary>
        ///   &apos;{0}&apos; は複数のモデルまたはアニメーションセットにバインドされています。閉じてもよろしいですか？
        /// </summary>
        IO_CloseAnimationBoundToObjects,
        /// <summary>
        ///   &apos;{0}&apos; はモデルまたはアニメーションセットにバインドされています。閉じてもよろしいですか？
        /// </summary>
        IO_CloseAnimationBoundToAnObject,
        /// <summary>
        ///   &apos;{0}&apos; は他のファイルから参照されています。閉じてもよろしいですか？
        /// </summary>
        IO_FileIsReferenced,
        /// <summary>
        /// マテリアルにマテリアル用でないシェーディングモデルが割り当てられています。
        /// </summary>
        IO_NotMaterialShaderAssined,
        /// <summary>
        /// 以下の読み込み済みファイルは更新されていないため、再読み込みされませんでした。
        /// </summary>
        DocumentManager_LoadFromFile_SkipReload,
        /// <summary>
        /// アニメーションのバインドに失敗しました。
        /// </summary>
        IO_FailedToBindDialog,
        /// <summary>
        /// 読み込んだファイルにエラーが含まれています。
        /// </summary>
        IO_InvalidItems,
        /// <summary>
        /// 以下のファイルの読み込みに失敗しました。
        /// </summary>
        IO_Load_Failed,
        /// <summary>
        /// 再生成されたシェーダー定義にエラーが含まれています。
        /// </summary>
        ShaderConvert_InvalidItems,
        /// <summary>
        /// 以下のファイルのユーザーデータに含まれていたリターゲット元情報をプロジェクトに移動しました。
        /// </summary>
        IO_SkeletalAnimation_MoveRetagetingHostModelToProject,

        //DocumentSaver
        /// <summary>
        /// プロジェクト保存時にパスが確定していないファイルがある
        /// </summary>
        NoFileLocation,
        /// <summary>
        /// 保存先ファイル '{0}' は読み取り専用です。名前を変更して保存しますか？
        /// </summary>
        IO_SaveFileReadOnly,
        /// <summary>
        ///   {0} はテクスチャパターンの範囲外のキーを含みます。
        ///保存を行いますか？
        /// </summary>
        TexturePatternAnimation_OutOfRange,
        /// <summary>
        /// {0} を開いたときにテクスチャの参照を解決できない可能性があります。
        /// </summary>
        IO_TextureReferenceCanNotResolved,

        // PrePostOpen
        /// <summary>
        /// オープン前コマンド
        /// </summary>
        IO_PreOpenCommand,
        /// <summary>
        /// 保存前コマンド
        /// </summary>
        IO_PreSaveCommand,
        /// <summary>
        /// 保存後コマンド
        /// </summary>
        IO_PostSaveCommand,
        /// <summary>
        /// バイナリ化前コマンド
        /// </summary>
        IO_PreBinarizeCommand,
        /// <summary>
        /// クローズ後コマンド
        /// </summary>
        IO_PostCloseCommand
    }

    public interface INotificationHandlerStringFormat
    {
        string UnsavedFile
        {
            get;
        }

        string UnresolvedTexture
        {
            get;
        }
    }

    public interface INotificationHandler
    {
        INotificationHandlerStringFormat StringFormat
        {
            get;
        }

        void WriteMessageLog(MessageLog.LogType type, string message, Action onDoubleClick = null);

        /// <summary>
        /// 情報メッセージ。
        /// </summary>
        void MessageBoxInformation(string message);
        void MessageBoxInformation(string format, params object[] args);

        /// <summary>
        /// 警告メッセージ。
        /// </summary>
        void MessageBoxWarning(string message);
        void MessageBoxWarning(string format, params object[] args);

        /// <summary>
        /// エラーメッセージ。
        /// </summary>
        void MessageBoxError(string message);
        void MessageBoxError(string format, params object[] args);

        /// <summary>
        /// はい、いいえメッセージ。
        /// </summary>
        bool MessageBoxYesNo(MessageContext context, string message);
        bool MessageBoxYesNo(MessageContext context, string format, params object[] args);

        /// <summary>
        /// はい、いいえ、キャンセルメッセージ。
        /// </summary>
        DialogResult MessageBoxYesNoCancel(MessageContext context, string message);
        DialogResult MessageBoxYesNoCancel(MessageContext context, string format, params object[] args);

        /// <summary>
        /// ＯＫ、キャンセルメッセージ。
        /// </summary>
        bool MessageBoxOkCancel(MessageContext context, string message);

        //
        void OkListBoxDialog(MessageContext context, string text, string label, IEnumerable<string> lines);

        bool OkCancelListBoxDialog(MessageContext context, string text, string label, string format, IEnumerable<Document> documents);
        bool OkCancelListBoxDialog(MessageContext context, string text, string label, string format, IEnumerable<Tuple<string, System.Drawing.Image>> items);
        bool OkCancelTextBoxDialog(MessageContext context, string text, string label, IEnumerable<string> lines);

        // DocumentManager
        bool DocumentsCloseDialog(IEnumerable<Document> modified, out IEnumerable<Document> saveRequired);

        void SkeletalAnimBindDialog(SkeletalAnimBindDialog.ErrorInfo[] skeletalAnimError, bool canCancel);

        IEnumerable<ShaderAssignUtility.MaterialAnimationError> FixShaderParamAnimDialog(ShaderAssignUtility.MaterialAnimationError[] errorMaterialAnims);

        bool SameFileReload(IEnumerable<Document> updateddocs);

        void FileErrorDialog(MessageContext context, IEnumerable<Tuple<string, string, string>> errors, string message);

        Model ModelSelectDialog(IEnumerable<Model> models, AnimationDocument animation, string chkText, ref bool applyAll);

        void FixLightAnimAssignDialog(LightAnimation[] errorLightAnims, out LightAnimation[] fixLightAnims, out LightAnimation[] notFixLightAnims);

        void FixShaderAssignDialog(Material[] errorMaterials, out Material[] fixMaterials, out Material[] notFixMaterials);

        // DocumentSaver
        List<Tuple<Document, string>> SaveDirectoryDialog(List<Document> saveDocuments);

        string SaveFileDialog(string filter, string ext, string title, string fileName = "", string fileLocation = "", bool prompt = true);
    }

}
