﻿using App.Command;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace App.Data
{
    public interface IHasShaderParameterAnimation
    {
        ShaderParameterAnimation.ParamAnim GetParamAnimFromId(string materialName, string p);

        nw.g3d.nw4f_3dif.G3dArrayElement<nw.g3d.nw4f_3dif.original_material_animType> OriginalMaterialAnimArray { get; }

        void UpdateParamAnimFromOriginalAnimTarget(string materialName, PropertyEdit.CurveTreeNode node, int p, nw.g3d.nw4f_3dif.original_color_animType original_color_animType, nw.g3d.nw4f_3dif.original_color_anim_targetType original_color_anim_targetType, nw.g3d.nw4f_3dif.original_texsrt_animType original_texsrt_animType, nw.g3d.nw4f_3dif.original_texsrt_anim_targetType original_texsrt_anim_targetType, Command.EditCommandSet commandSet);

        void UpdateParamAnimFromSpecificOriginalAnim(string materialName, PropertyEdit.CurveTreeNode node, nw.g3d.nw4f_3dif.original_color_animType original_color_animType, nw.g3d.nw4f_3dif.original_texsrt_animType original_texsrt_animType, Command.EditCommandSet commandSet);

        void UpdateParamAnimFromOriginalAnim(string p, IEnumerable<PropertyEdit.CurveTreeNode> nodes, Command.EditCommandSet commandSet);

        bool IsExistOriginalAnim();

        bool IsExistOriginalParamAnim(string p, IEnumerable<PropertyEdit.CurveTreeNode> nodes);

        bool IsExistOriginalParamAnim(string p, PropertyEdit.CurveTreeNode node);

        bool HasAnyShaderParamCurves();

        // 全体に対してオリジナルを適用する。
        void ApplyOriginalAnimation(EditCommandSet commandSet, bool isLoadAnimation);

        // シェーダーパラメーター全般か？(カラーアニメーションやテクスチャ SRT は除く)
        bool IsShaderParameterType();

        // テクスチャ SRT をもつか？
        bool IsTextureSrtType();

        // テクスチャ SRT をもつか？
        bool IsColorType();

        IEnumerable<IShaderParamMatAnim> IShaderParamMatAnims { get; }

        void UpdateIsModifiedAnimTargetAll();
    }

    public interface IShaderParamMatAnim
    {
        string mat_name { get; set; }
        ShaderParameterAnimation.ParamAnimList ParamAnims { get; set; }
    }
}
