﻿using System;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using App.Data;
using App.Utility;

namespace App.Controls
{
    public sealed partial class TexturePatternTextureSelectDialog : OkCancelDialog
    {
        // テクスチャパターンのインデックス
        private int selectedIndex_ = -1;
        public int SelectedIndex
        {
            get
            {
                return selectedIndex_;
            }

            set
            {
                selectedIndex_ = Math.Max(0, Math.Min(value, texPatternAnim_.TexPatterns.Count - 1));
            }
        }

        // ３２サイズイメージリスト
        private static readonly ImageList iml32Size_ = new ImageList()
        {
            ImageSize = new Size(32+2, 32+2),
            ColorDepth = ColorDepth.Depth8Bit,
            TransparentColor = Color.Magenta,
        };

        // ６４サイズイメージリスト
        private static readonly ImageList iml64Size_ = new ImageList()
        {
            ImageSize = new Size(64+2, 64+2),
            ColorDepth = ColorDepth.Depth8Bit,
            TransparentColor = Color.Magenta,
        };

        private readonly IHasTexturePatternAnimation texPatternAnim_;

        public TexturePatternTextureSelectDialog(IHasTexturePatternAnimation texPatternAnim)
        {
            Debug.Assert(texPatternAnim != null);
            texPatternAnim_ = texPatternAnim;

            InitializeComponent();

            DialogUtility.SetHelp(this, HelpUtility.PageKey.p_animation_property_window_pattern_page_a_tex_pattern_change);

            // 行の高さを変更
            lvwList.SmallImageList = iml32Size_;
            lvwList.LargeImageList = iml64Size_;

            UpdateList();
        }

        protected override bool OnResultOk()
        {
            SelectedIndex = lvwList.SelectedIndex;

            return true;
        }

        private void UpdateList()
        {
            using(var block = new UpdateBlock(lvwList))
            {
                lvwList.SetItemCount(texPatternAnim_.TexPatterns.Count);

                int index = 0;
                foreach (var texPattern in texPatternAnim_.TexPatterns)
                {
                    ListViewItem item = lvwList.Items[index];
                    item.Tag = texPattern.tex_name;

                    item.SubItems[clhIndex.Index].Text	= index.ToString();
                    item.SubItems[clhName.Index].Text	= texPattern.tex_name;
                    item.SubItems[clhImage.Index].Text	= string.Empty;

                    ++ index;
                }
            }

            if (lvwList.Items.Count > 0)
            {
                if ((SelectedIndex != -1) && (SelectedIndex < lvwList.Items.Count))
                {
                    lvwList.Items[SelectedIndex].Selected = true;
                    lvwList.Items[SelectedIndex].Focused = true;
                }
            }
        }

        private void lvwList_CustomDrawItem(object sender, CustomDrawListViewItemEventArgs e)
        {
            if (e.Item != null)
            {
                var	texName	= e.Item.Tag as string;
                var	texture	= DocumentManager.Textures.FirstOrDefault(x => x.Name == texName);

                if (e.ColumnIndex == 0)
                {
                    if (texture != null)
                    {
                        GraphicsUtility.DrawTextureImage(texture, e.Graphics, e.Bounds);
                    }

                    e.Handled = true;
                }

                // 文字色
                {
                    e.SpecificForeColor = (texture == null) ? Const.DisreferenceColor : SystemColors.WindowText;
                }
            }
        }
    }
}
