﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using App.Utility;
using nw.g3d.nw4f_3dif;

namespace App.Controls
{
    /// <summary>
    /// アニメーションを選択するダイアログクラス。
    /// </summary>
    public sealed partial class OriginalAnimOverwriteSelectionDialog : OkCancelDialog
    {
        // 更新するカラーアニメーション
        private original_color_animType _overwriteColor = null;
        // 更新するカラーアニメーションターゲット
        private original_color_anim_targetType _overwriteColorTarget = null;
        // 更新するtexSRTアニメーション
        private original_texsrt_animType _overwriteTexSRT = null;
        // 更新するtexSRTアニメーションターゲット
        private original_texsrt_anim_targetType _overwriteTexSRTTarget = null;
        // フォームサイズ
        private static Size _formSize = Size.Empty;

        private const string _colorAnimType = "color animation";
        private const string _texSRTAnimType = "texSRT animation";

        private static readonly Dictionary<string, original_color_anim_target_targetType> originalColorAnimTargetType_ = new Dictionary<string, original_color_anim_target_targetType>()
        {
            {"color_r", original_color_anim_target_targetType.color_r},
            {"color_g", original_color_anim_target_targetType.color_g},
            {"color_b", original_color_anim_target_targetType.color_b},
        };

        private static readonly Dictionary<string, original_texsrt_anim_target_targetType> originalTexSRTAnimTargetType_ = new Dictionary<string, original_texsrt_anim_target_targetType>()
        {
            {"scale_x",     original_texsrt_anim_target_targetType.scale_x},
            {"scale_y",     original_texsrt_anim_target_targetType.scale_y},
            {"rotate",      original_texsrt_anim_target_targetType.rotate},
            {"translate_x", original_texsrt_anim_target_targetType.translate_x},
            {"translate_y", original_texsrt_anim_target_targetType.translate_y},
        };

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public OriginalAnimOverwriteSelectionDialog(G3dArrayElement<original_material_animType> originalMatAnims, bool modeElement, bool modeColor)
        {
            InitializeComponent();

            if (modeElement)
            {
                // カラーとTexSRTの両方を、要素の数分入れる
                // ファイルリスト構築
                foreach (var originalMatAnim in originalMatAnims.Items)
                {
                    if (originalMatAnim.original_color_anim_array != null)
                    {
                        foreach (var colorAnim in originalMatAnim.original_color_anim_array.original_color_anim)
                        {
                            foreach (var target in colorAnim.original_color_anim_target)
                            {
                                ListViewItem item = new ListViewItem(colorAnim.hint);
                                item.Tag = colorAnim;
                                item.Checked = false;
                                item.SubItems.Add(target.target.ToString());
                                item.SubItems.Add(_colorAnimType);
                                item.SubItems.Add(originalMatAnim.mat_name);
                                lvwFileList.Items.Add(item);
                            }
                        }
                    }

                    if (originalMatAnim.original_texsrt_anim_array != null)
                    {
                        foreach (var texSTRAnim in originalMatAnim.original_texsrt_anim_array.original_texsrt_anim)
                        {
                            foreach (var target in texSTRAnim.original_texsrt_anim_target)
                            {
                                ListViewItem item = new ListViewItem(texSTRAnim.hint);
                                item.Tag = texSTRAnim;
                                item.Checked = false;
                                item.SubItems.Add(target.target.ToString());
                                item.SubItems.Add(_texSRTAnimType);
                                item.SubItems.Add(originalMatAnim.mat_name);
                                lvwFileList.Items.Add(item);
                            }
                        }
                    }
                }

            }
            else
            {
                clhAnimTarget.Width = 0;

                // ファイルリスト構築
                foreach (var originalMatAnim in originalMatAnims.Items)
                {
                    if (modeColor)
                    {
                        if (originalMatAnim.original_color_anim_array != null)
                        {
                            foreach (var colorAnim in originalMatAnim.original_color_anim_array.original_color_anim)
                            {
                                ListViewItem item = new ListViewItem(colorAnim.hint);
                                item.Tag = colorAnim;
                                item.Checked = false;
                                item.SubItems.Add(string.Empty);
                                item.SubItems.Add(_colorAnimType);
                                item.SubItems.Add(originalMatAnim.mat_name);
                                lvwFileList.Items.Add(item);
                            }
                        }
                    }
                    else
                    {
                        if (originalMatAnim.original_texsrt_anim_array != null)
                        {
                            foreach (var texSTRAnim in originalMatAnim.original_texsrt_anim_array.original_texsrt_anim)
                            {
                                ListViewItem item = new ListViewItem(texSTRAnim.hint);
                                item.Tag = texSTRAnim;
                                item.Checked = false;
                                item.SubItems.Add(string.Empty);
                                item.SubItems.Add(_texSRTAnimType);
                                item.SubItems.Add(originalMatAnim.mat_name);
                                lvwFileList.Items.Add(item);
                            }
                        }
                    }
                }
            }


            lvwFileList.Sort(false);
            lvwFileList_VisibleChanged(lvwFileList, EventArgs.Empty);
            lvwFileList.CheckBoxes = false;

            // サイズ設定
            if (_formSize != Size.Empty) { Size = _formSize; }
            FormClosed += delegate { _formSize = Size; };
        }

        public original_color_animType OverWriteColorAnim { get { return _overwriteColor; } }
        public original_color_anim_targetType OverWriteColorAnimTarget { get { return _overwriteColorTarget; } }
        public original_texsrt_animType OverWriteTexSRTAnim { get { return _overwriteTexSRT; } }
        public original_texsrt_anim_targetType OverWriteTexSRTAnimTarget { get { return _overwriteTexSRTTarget; } }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool OnResultOk()
        {
            _overwriteColor = null;
            _overwriteTexSRT = null;
            _overwriteColorTarget = null;
            _overwriteTexSRTTarget = null;

            // 選択されたカーブの先頭のものを設定する。
            foreach (ListViewItem item in lvwFileList.SelectedItems)
            {
                if (item.SubItems[2].Text == _colorAnimType)
                {
                    _overwriteColor = (original_color_animType)item.Tag;
                    if (!string.IsNullOrEmpty(item.SubItems[1].Text))
                    {
                        original_color_anim_target_targetType targetType = originalColorAnimTargetType_[item.SubItems[1].Text];
                        foreach (var target in _overwriteColor.original_color_anim_target)
                        {
                            if (target.target == targetType)
                            {
                                _overwriteColorTarget = target;
                                break;
                            }
                        }
                    }

                    break;
                }
                else if (item.SubItems[2].Text == _texSRTAnimType)
                {
                    _overwriteTexSRT = (original_texsrt_animType)item.Tag;
                    if (!string.IsNullOrEmpty(item.SubItems[1].Text))
                    {
                        original_texsrt_anim_target_targetType targetType = originalTexSRTAnimTargetType_[item.SubItems[1].Text];
                        foreach (var target in _overwriteTexSRT.original_texsrt_anim_target)
                        {
                            if (target.target == targetType)
                            {
                                _overwriteTexSRTTarget = target;
                                break;
                            }
                        }
                    }
                    break;
                }
            }

            if (_overwriteColor == null && _overwriteTexSRT == null)
            {
                return false;
            }

            return true;
        }

        //---------------------------------------------------------------------
        // ファイルリスト

        private void lvwFileList_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            // チェックされていなければ OK ボタンは有効にならない
            btnOK.Enabled = lvwFileList.CheckedItems.Count > 0;
        }

        private void lvwFileList_ItemSelectionChanged(object sender, ListViewItemSelectionChangedEventArgs e)
        {
            if (lvwFileList.SelectedItems.Count == 1)
            {
                btnOK.Enabled = true;
            }
            else
            {
                btnOK.Enabled = false;
            }
        }

        private void lvwFileList_VisibleChanged(object sender, EventArgs e)
        {
            lvwFileList.BeginInvokeOrExecute(new Action(() =>
                {
                    if (lvwFileList.ClientSize.Width > 0)
                    {
                        clhAnimName.Width = lvwFileList.ClientSize.Width - clhAnimType.Width - clhAnimTarget.Width - clhMaterialName.Width;
                    }
                }));
        }
    }
}
