﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.ComponentModel;
using System.Windows.Forms;

namespace App.Controls
{
    /// <summary>
    /// モードレスダイアログクラス。
    /// </summary>
    public partial class ModelessDialog : UIForm // abstract
    {
        public event FormClosingEventHandler FormClosingByEscapeKey = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ModelessDialog()
        {
            InitializeComponent();
        }

        #region デザイナ制御
        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new bool IsMdiContainer
        {
            get { return base.IsMdiContainer;  }
            set { base.IsMdiContainer = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new FormWindowState WindowState
        {
            get { return base.WindowState;  }
            set { base.WindowState = value; }
        }
        #endregion

        #region オーバーライド
        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
        {
            // 既定の処理
            if (base.ProcessCmdKey(ref msg, keyData))
            {
                return true;
            }
            // メインフレームのショートカット処理
            return TheApp.MainFrame.ProcessCommandKey(ref msg, keyData);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool ProcessDialogKey(Keys keyData)
        {
            // Escキーで閉じる
            if (keyData == Keys.Escape)
            {
                // 閉じるボタンが存在する場合のみ
                if (ControlBox)
                {
                    bool close = true;
                    if (FormClosingByEscapeKey != null)
                    {
                        var args = new FormClosingEventArgs(CloseReason.UserClosing, false);
                        FormClosingByEscapeKey(this, args);
                        close = !args.Cancel;
                    }
                    if (close)
                    {
                        Close();
                    }
                }
            }
            return base.ProcessDialogKey(keyData);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnLoad(EventArgs e)
        {
            if (!DesignMode)
            {
                // サイズ変更モード時の設定
                if (FormBorderStyle == FormBorderStyle.Sizable)
                {
                    // アイコン
                    Icon = TheApp.MainFrame.Icon;
                }
            }
            base.OnLoad(e);
        }
        #endregion
    }
}
