﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace App.Controls
{
    public partial class PresetShaderParameterFilterDialog : OkCancelDialog
    {
        public class TagData
        {
            public TeamConfig.Preset.ShaderParameterFilter ShaderParameterFilter;

            public TagData(TeamConfig.Preset.ShaderParameterFilter shaderParameterFilter)
            {
                ShaderParameterFilter = shaderParameterFilter;
            }
        };

        const int EM_SETCUEBANNER = 0x1500 + 1;

        private List<Func<bool>> acceptable = new List<Func<bool>>();

        public PresetShaderParameterFilterDialog()
        {
            InitializeComponent();
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            // 入力必須項目に設定。
            if (tbxShaderParameterFilterName.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.MandatoryField);
                Win32.NativeMethods.SendMessage(tbxShaderParameterFilterName.Handle, EM_SETCUEBANNER, IntPtr.Zero, ptr);
                acceptable.Add(() => { return !string.IsNullOrEmpty(tbxShaderParameterFilterName.Text); });
            }

            // 書式を設定。
            if (tbxShaderParameterFilterInclude.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.PresetShaderParameterFilter_IncludeCueBanner);
                Win32.NativeMethods.SendMessage(tbxShaderParameterFilterInclude.Handle, EM_SETCUEBANNER, IntPtr.Zero, ptr);
            }

            // 書式を設定。
            if (tbxShaderParameterFilterExclude.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.PresetShaderParameterFilter_ExcludeCueBanner);
                Win32.NativeMethods.SendMessage(tbxShaderParameterFilterExclude.Handle, EM_SETCUEBANNER, IntPtr.Zero, ptr);
            }

            var data = (TagData)Tag;
            tbxShaderParameterFilterName.Text = data.ShaderParameterFilter.Name;
            tbxShaderParameterFilterInclude.Text = data.ShaderParameterFilter.Include;
            tbxShaderParameterFilterExclude.Text = data.ShaderParameterFilter.Exclude;
            cbxShaderParameterFilterIgnorePage.Checked = data.ShaderParameterFilter.IgnorePage;
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            base.OnClosing(e);

            // e.Cancel 操作は base.OnClosing() 後に行う必要がある。
            if ((DialogResult == DialogResult.OK) && !acceptable.All(x => x()))
            {
                e.Cancel = true;
            }
        }

        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // 変更を適用。
            if (DialogResult == DialogResult.OK)
            {
                // null 文字から空文字への変更を回避。
                Func<string, string, string> CorrectString = (oldValue, newValue) =>
                {
                    return ((oldValue == null) && string.IsNullOrEmpty(newValue)) ? null : newValue;
                };

                var data = (TagData)Tag;
                data.ShaderParameterFilter.Name = CorrectString(data.ShaderParameterFilter.Name, tbxShaderParameterFilterName.Text);
                data.ShaderParameterFilter.Include = CorrectString(data.ShaderParameterFilter.Include, tbxShaderParameterFilterInclude.Text);
                data.ShaderParameterFilter.Exclude = CorrectString(data.ShaderParameterFilter.Exclude, tbxShaderParameterFilterExclude.Text);
                data.ShaderParameterFilter.IgnorePage = cbxShaderParameterFilterIgnorePage.Checked;
            }
        }
    }
}
