﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace App.Controls
{
    public partial class PresetAttnDialog : OkCancelDialog
    {
        /// <summary>
        /// Tag に設定するデータ
        /// </summary>
        public class TagData
        {
            public string AttnType;
            public TeamConfig.Preset.AttenuationFunction AttnFunc;
            public Func<string, List<TeamConfig.Preset.AttenuationFunction>> GetAttenuationPresets;

            public TagData(string attnType, TeamConfig.Preset.AttenuationFunction attnFunc, Func<string, List<TeamConfig.Preset.AttenuationFunction>> getAttenuationPresets)
            {
                AttnType = attnType;
                AttnFunc = attnFunc;
                GetAttenuationPresets = getAttenuationPresets;
            }
        }

        const int EM_SETCUEBANNER = 0x1500 + 1;
        const int CB_SETCUEBANNER = 0x1703;

        private List<Func<bool>> acceptable = new List<Func<bool>>();

        public PresetAttnDialog()
        {
            InitializeComponent();
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            TagData data = (TagData)Tag;

            cbxAttnType.Items.Clear();
            cbxAttnType.Items.Add(new UIListControlItem(App.res.Strings.TeamConfigSettingDialog_pnlPreset_LightDistAttnFunc, 0));
            cbxAttnType.Items.Add(new UIListControlItem(App.res.Strings.TeamConfigSettingDialog_pnlPreset_LightAngleAttnFunc, 1));
            cbxAttnType.Items.Add(new UIListControlItem(App.res.Strings.TeamConfigSettingDialog_pnlPreset_FogDistAttnFunc, 2));
            cbxAttnType.SelectedItem = cbxAttnType.Items.Cast<UIListControlItem>().FirstOrDefault(x => x.Text == data.AttnType);
            tbxAttnLabel.Text = data.AttnFunc.Label;
            tbxAttnFunction.Text = data.AttnFunc.Function;

            // 入力必須項目に設定。
            if (cbxAttnType.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.MandatoryField);
                Win32.NativeMethods.SendMessage(cbxAttnType.Handle, CB_SETCUEBANNER, IntPtr.Zero, ptr);
                acceptable.Add(() => { return cbxAttnType.SelectedItem != null; });
            }
            if (tbxAttnFunction.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.MandatoryField);
                Win32.NativeMethods.SendMessage(tbxAttnFunction.Handle, EM_SETCUEBANNER, IntPtr.Zero, ptr);
                acceptable.Add(() => { return !string.IsNullOrEmpty(tbxAttnFunction.Text); });
            }
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            base.OnClosing(e);

            // e.Cancel 操作は base.OnClosing() 後に行う必要がある。
            if (DialogResult == DialogResult.OK)
            {
                if (!acceptable.All(x => x()))
                {
                    e.Cancel = true;
                    return;
                }

                TagData data = (TagData)Tag;

                var item = (UIListControlItem)cbxAttnType.SelectedItem;
                if (item != null)
                {
                    var attenType = item.Text;
                    var functions = data.GetAttenuationPresets(attenType).Where(x => x != data.AttnFunc);

                    // 同名のラベルは許可しない。
                    if (functions.Any(x => x.Label == tbxAttnLabel.Text))
                    {
                        UIMessageBox.Error(res.Strings.Preset_Load_Duplicated_Func_Or_Label, attenType, tbxAttnLabel.Text);
                        e.Cancel = true;
                        return;
                    }

                    // 同名の関数は許可しない。
                    if (functions.Any(x => x.Function == tbxAttnFunction.Text))
                    {
                        UIMessageBox.Error(res.Strings.Preset_Load_Duplicated_Func_Or_Label, attenType, tbxAttnFunction.Text);
                        e.Cancel = true;
                        return;
                    }
                }
            }
        }

        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // 変更を適用。
            if (DialogResult == DialogResult.OK)
            {
                // null 文字から空文字への変更を回避。
                Func<string, string, string> CorrectString = (oldValue, newValue) =>
                {
                    return ((oldValue == null) && string.IsNullOrEmpty(newValue)) ? null : newValue;
                };

                var data = (TagData)Tag;
                if (cbxAttnType.SelectedItem != null)
                {
                    var item = (UIListControlItem)cbxAttnType.SelectedItem;
                    data.AttnType = CorrectString(data.AttnType, item.Text);
                }
                data.AttnFunc.Function = CorrectString(data.AttnFunc.Function, tbxAttnFunction.Text);
                data.AttnFunc.Label = CorrectString(data.AttnFunc.Label, tbxAttnLabel.Text);
            }
        }
    }
}
