﻿using System;
using System.Drawing;
using System.Windows.Forms;
using App.ConfigData;

namespace App.Controls
{
    /// <summary>
    /// カラーピッカーダイアログクラス。
    /// </summary>
    [Obsolete("Not maintained")]
    public sealed partial class SimpleColorPickerDialog : OkCancelDialog
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public SimpleColorPickerDialog()
        {
            InitializeComponent();

            LoadConfig();

            ctlColorPicker.IsDefaultLinear = ConfigData.ApplicationConfig.Color.GammaCorrection;
        }

        /// <summary>
        /// カラー。
        /// </summary>
        public ColorPicker.RGB Color
        {
            get { return ctlColorPicker.SrgbColor; }
            set
            {
                if (ctlColorPicker.SrgbColor != value)
                {
                    ctlColorPicker.SetColor(value);
                }
            }
        }

        /// <summary>
        /// カラーモード。
        /// </summary>
        public ConfigCommon.ColorMode ColorMode
        {
            get { return ctlColorPicker.ColorMode; }
            set { ctlColorPicker.ColorMode = value; }
        }

        /// <summary>
        /// 値モード。
        /// </summary>
        public ConfigCommon.ValueMode ValueMode
        {
            get { return ctlColorPicker.ValueMode; }
            set { ctlColorPicker.ValueMode = value; }
        }

        public bool hasA
        {
            get
            {
                switch (ColorMode)
                {
                    case ConfigCommon.ColorMode.A:
                    case ConfigCommon.ColorMode.HSVA:
                    case ConfigCommon.ColorMode.RGBA:
                    case ConfigCommon.ColorMode.LinearRgba:
                        return true;
                    default:
                        return false;
                }
            }
            set
            {
                if (value)
                {
                    switch (ColorMode)
                    {
                        case ConfigCommon.ColorMode.RGB:
                            ColorMode = ConfigCommon.ColorMode.RGBA;
                            break;
                        case ConfigCommon.ColorMode.LinearRgb:
                            ColorMode = ConfigCommon.ColorMode.LinearRgba;
                            break;
                        case ConfigCommon.ColorMode.HSV:
                            ColorMode = ConfigCommon.ColorMode.HSVA;
                            break;
                    }
                }
                else
                {
                    switch (ColorMode)
                    {
                        case ConfigCommon.ColorMode.RGBA:
                        case ConfigCommon.ColorMode.A:
                            ColorMode = ConfigCommon.ColorMode.RGB;
                            break;
                        case ConfigCommon.ColorMode.LinearRgba:
                            ColorMode = ConfigCommon.ColorMode.LinearRgb;
                            break;
                        case ConfigCommon.ColorMode.HSVA:
                            ColorMode = ConfigCommon.ColorMode.HSV;
                            break;
                    }
                }
            }
        }

        private float _HDR;
        public float HDR
        {
            set
            {
                _HDR = value;
                if (value != 1f)
                {
                    lblHDR.Text = string.Format("HDR={0}", value);
                }
                else
                {
                    lblHDR.Visible = false;
                }
            }
        }

        public void FitSize()
        {
            if (_HDR != 1f)
            {
                switch (ColorMode)
                {
                    case ConfigCommon.ColorMode.HSVA:
                    case ConfigCommon.ColorMode.RGBA:
                    case ConfigCommon.ColorMode.LinearRgba:
                        lblHDR.Location = new Point(lblHDR.Location.X, lblHDR.Location.Y + 24);
                        break;
                    case ConfigCommon.ColorMode.RGB:
                    case ConfigCommon.ColorMode.HSV:
                    case ConfigCommon.ColorMode.LinearRgb:
                        ctlColorPicker.Size = new Size(ctlColorPicker.Size.Width, ctlColorPicker.Size.Height - 24);
                        //btnOK.Location = new Point(btnOK.Location.X, btnOK.Location.Y - 24);
                        //btnCancel.Location = new Point(btnCancel.Location.X, btnCancel.Location.Y - 24);
                        Size = new Size(Size.Width, Size.Height - 24);
                        break;
                }
            }
            else
            {
                switch (ColorMode)
                {
                    case ConfigCommon.ColorMode.HSV:
                    case ConfigCommon.ColorMode.RGB:
                    case ConfigCommon.ColorMode.LinearRgb:
                        ctlColorPicker.Size = new Size(ctlColorPicker.Size.Width, ctlColorPicker.Size.Height - 24);
                        //btnOK.Location = new Point(btnOK.Location.X, btnOK.Location.Y - 24);
                        //btnCancel.Location = new Point(btnCancel.Location.X, btnCancel.Location.Y - 24);
                        Size = new Size(Size.Width, Size.Height - 24);
                        break;
                }
            }
        }

        private void SimpleColorPickerDialog_FormClosed(object sender, FormClosedEventArgs e)
        {
            SaveConfig();
        }

        private void LoadConfig()
        {
            var config = ApplicationConfig.Setting.ColorPicker;

            for (int i = 0; i < AppConfig.ColorPicker.CustomColorCount; i++)
            {
                ctlColorPicker.CustomColors[i] = new ColorPicker.RGB(
                    config.CustomColor[i][0],
                    config.CustomColor[i][1],
                    config.CustomColor[i][2]);
            }
            ColorMode = config.ColorMode;
            ValueMode = config.ValueMode;

            if (config.Location != null)
            {
                DesktopLocation = (Point)config.Location;
            }
            else
            {
                StartPosition = FormStartPosition.CenterParent;
            }
        }

        private void SaveConfig()
        {
            var config = ApplicationConfig.Setting.ColorPicker;

            for (int i = 0; i < AppConfig.ColorPicker.CustomColorCount; i++)
            {
                // 切り捨てておけば誤差に悩まされない
                config.CustomColor[i] = ColorPickerDialog.ToRgbaColor(ctlColorPicker.CustomColors[i], 1).ToArray();
            }
            config.ColorMode = ColorMode;
            config.ValueMode = ValueMode;

            config.Location = DesktopLocation;
        }

        private void ctlColorPicker_ColorChanged(object sender, ColorPicker.ColorChangedEventArgs e)
        {
            if (ColorChangedOnColorPicker != null)
            {
                ColorChangedOnColorPicker(sender, e);
            }
        }

        public event EventHandler ColorChangedOnColorPicker;
    }
}
