﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using nw.g3d.nw4f_3dif;

namespace App.Controls
{
    public static class ColorComponentSelectCommon
    {
        static readonly Dictionary<texture_info_comp_selValue, Brush> brushDict = new Dictionary<texture_info_comp_selValue, Brush>()
        {
            {texture_info_comp_selValue.r, Brushes.Red},
            {texture_info_comp_selValue.g, Brushes.Lime},
            {texture_info_comp_selValue.b, Brushes.Blue},
            {texture_info_comp_selValue.a, new HatchBrush(HatchStyle.LargeCheckerBoard, System.Drawing.Color.Gray)},
            {texture_info_comp_selValue.Item0, Brushes.Black},
            {texture_info_comp_selValue.Item1, Brushes.White},
        };

        static readonly Dictionary<texture_info_comp_selValue, string> stringDict = new Dictionary<texture_info_comp_selValue, string>()
        {
            {texture_info_comp_selValue.r, "R"},
            {texture_info_comp_selValue.g, "G"},
            {texture_info_comp_selValue.b, "B"},
            {texture_info_comp_selValue.a, "A"},
            {texture_info_comp_selValue.Item0, "0"},
            {texture_info_comp_selValue.Item1, "1"},
        };

        public static void DrawColor(Graphics g, Rectangle rect, texture_info_comp_selValue[] value, bool enabled)
        {
            var x = new []
            {
                rect.Left + rect.Width * 0 / 4,
                rect.Left + rect.Width * 1 / 4,
                rect.Left + rect.Width * 2 / 4,
                rect.Left + rect.Width * 3 / 4,
                rect.Left + rect.Width * 4 / 4,
            };

            if ((value == null) || (enabled == false))
            {
                g.DrawRectangle(Pens.DarkGray, rect);
                g.DrawLine(Pens.DarkGray, x[1], rect.Top, x[1], rect.Bottom);
                g.DrawLine(Pens.DarkGray, x[2], rect.Top, x[2], rect.Bottom);
                g.DrawLine(Pens.DarkGray, x[3], rect.Top, x[3], rect.Bottom);
            }
            else
            {
                Debug.Assert(value.Length == 4);

                // 色
                for(int i = 0;i != 4;++ i)
                {
                    var r = new Rectangle(x[i], rect.Top, rect.Width / 4 + 1, rect.Height);
                    g.FillRectangle(brushDict[value[i]], r);
                }

                // 枠
                {
                    g.DrawRectangle(Pens.Black, rect);
                    g.DrawLine(Pens.Black, x[1], rect.Top, x[1], rect.Bottom);
                    g.DrawLine(Pens.Black, x[2], rect.Top, x[2], rect.Bottom);
                    g.DrawLine(Pens.Black, x[3], rect.Top, x[3], rect.Bottom);
                }

                // 字
                {
                    int cellWidth  = rect.Width / 4 + 1;
                    int cellHeight = rect.Height + 1;

                    var charSize0	= g.MeasureString(stringDict[value[0]], TheApp.GuiFontBold);
                    var charSize1	= g.MeasureString(stringDict[value[1]], TheApp.GuiFontBold);
                    var charSize2	= g.MeasureString(stringDict[value[2]], TheApp.GuiFontBold);
                    var charSize3	= g.MeasureString(stringDict[value[3]], TheApp.GuiFontBold);

                    int offsetX0 = (cellWidth  - (int)(charSize0.Width  + 1.0f)) / 2;
                    int offsetY0 = (cellHeight - (int)(charSize0.Height + 1.0f)) / 2;
                    int offsetX1 = (cellWidth  - (int)(charSize1.Width  + 1.0f)) / 2;
                    int offsetY1 = (cellHeight - (int)(charSize1.Height + 1.0f)) / 2;
                    int offsetX2 = (cellWidth  - (int)(charSize2.Width  + 1.0f)) / 2;
                    int offsetY2 = (cellHeight - (int)(charSize2.Height + 1.0f)) / 2;
                    int offsetX3 = (cellWidth  - (int)(charSize3.Width  + 1.0f)) / 2;
                    int offsetY3 = (cellHeight - (int)(charSize3.Height + 1.0f)) / 2;

                    g.DrawString(stringDict[value[0]], TheApp.GuiFontBold, Brushes.Black, x[0] + offsetX0, rect.Top + offsetY0);
                    g.DrawString(stringDict[value[1]], TheApp.GuiFontBold, Brushes.Black, x[1] + offsetX1, rect.Top + offsetY1);
                    g.DrawString(stringDict[value[2]], TheApp.GuiFontBold, Brushes.Black, x[2] + offsetX2, rect.Top + offsetY2);
                    g.DrawString(stringDict[value[3]], TheApp.GuiFontBold, Brushes.Black, x[3] + offsetX3, rect.Top + offsetY3);

                    g.DrawString(stringDict[value[0]], TheApp.GuiFontBold, Brushes.PapayaWhip, x[0] + offsetX0 - 1, rect.Top + offsetY0);
                    g.DrawString(stringDict[value[1]], TheApp.GuiFontBold, Brushes.PapayaWhip, x[1] + offsetX1 - 1, rect.Top + offsetY1);
                    g.DrawString(stringDict[value[2]], TheApp.GuiFontBold, Brushes.PapayaWhip, x[2] + offsetX2 - 1, rect.Top + offsetY2);
                    g.DrawString(stringDict[value[3]], TheApp.GuiFontBold, Brushes.PapayaWhip, x[3] + offsetX3 - 1, rect.Top + offsetY3);
                }
            }
        }
    }
}
