﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using App.Data;
using ConfigCommon;
using nw.g3d.nw4f_3dif;

namespace App.Controls
{
    public class AnimationSettingPopupButton : UIToolStripButton
    {
        private texture_info_comp_selValue[] _value;
        public texture_info_comp_selValue[] Value
        {
            get{
                return _value;
            }
            set
            {
                _value = value;
                Invalidate();
            }
        }

        //public event EventHandler PopupClose = null;
        public bool IsChangeValue{ get; private set; }

        public AnimationSettingPopupButton()
        {
            //Appearance = Appearance.Button;
        }

        private const int ArrowSize = 3;
        private const int ArrowEdgeSize = 4;
        private void DrawArrow(Graphics g, Rectangle rect)
        {
            Point[] vtx = {
                new Point(rect.Left  - 2, (rect.Top + rect.Bottom) / 2 - 1),
                new Point(rect.Right - 2, (rect.Top + rect.Bottom) / 2 - 1),
                new Point((rect.Left + rect.Right) / 2 - 2, (rect.Top + rect.Bottom) / 2 + ArrowSize)
            };

            g.SmoothingMode = SmoothingMode.Default;
            g.FillPolygon(Enabled ? Brushes.Black : Brushes.Gray, vtx);
        }

        private class Popup : Form // ToolStripDropDown
        {
            public  AnimationSettingPopupBase _picker;

            public Size PickerSize()
            {
                return new Size(_picker.Width, _picker.Height);
            }

            public Popup(GuiObjectGroup targetGroup)
            {
                this.Tag = targetGroup;
                var active = targetGroup.Active;
                switch (active.ObjectID)
                {
                    case GuiObjectID.MaterialAnimation:
                        _picker = new MaterialAnimationSettingPopup(this);
                        break;
                    case GuiObjectID.ShaderParameterAnimation:
                    case GuiObjectID.TextureSrtAnimation:
                    case GuiObjectID.ColorAnimation:
                        _picker = new ShaderAnimationSettingPopup(this);
                        break;
                    case GuiObjectID.SkeletalAnimation:
                        _picker = new SkeletalAnimationSettingPopup(this);
                        break;
                    default:
                        _picker = new GeneralAnimationSettingPopup(this);
                        break;
                }

                //var host = new ToolStripControlHost(_picker);


                AutoSize		= true;
                DoubleBuffered	= true;
                ResizeRedraw	= true;
                ControlBox = false;
                //AutoScaleMode = AutoScaleMode.Font;
                StartPosition = FormStartPosition.Manual;
                FormBorderStyle = FormBorderStyle.None;

                //Padding = Margin = host.Padding = host.Margin = Padding.Empty;
                MinimumSize = _picker.MinimumSize;
                _picker.MinimumSize = _picker.Size;
                MaximumSize = new Size(_picker.Size.Width + 1, _picker.Size.Height + 1);
                _picker.MaximumSize = new Size(_picker.Size.Width + 1, _picker.Size.Height + 1);
                Size = new Size(_picker.Size.Width + 1, _picker.Size.Height + 1);

                _picker.Location = Point.Empty;
                Controls.Add(_picker);
                //Items.Add(host);
            }

            protected override void OnDeactivate(EventArgs e)
            {
                if (!_picker.IsEditing())
                {
                    BeginInvoke(new MethodInvoker(Close));
                    base.OnDeactivate(e);
                }
            }

        }

        private Popup _popup;
        public GuiObjectGroup TargetGroup { get; set; }

        protected override void OnClick(EventArgs e)
        {
            base.OnClick(e);

            Debug.Assert(TargetGroup != null);


            IsChangeValue = false;

            if(_popup != null){
                _popup.Dispose();
                _popup = null;
            }

            Enabled = false;
            //Refresh();

            _popup = new Popup(TargetGroup);
            _popup.Closed += (s, a) =>
            {

                Checked = false;
                Enabled = true;

                Invalidate();
            };
            DebugConsole.WriteLine(Bounds.ToString());
            Rectangle rect = Parent.RectangleToScreen(Bounds);
            var pickersize = _popup.PickerSize();
            _popup.Location = new Point(rect.Right - pickersize.Width, rect.Top - pickersize.Height);
            DebugConsole.WriteLine(_popup.Location.ToString());
            _popup.Show(Parent);
        }


    }
}
