﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "msclr/marshal.h"
#include "msclr/marshal_windows.h"
#include "msclr/marshal_cppstd.h"
#include "msclr/marshal_atl.h"
#include "HIO.h"

#include "TextureCommandMaker.h"
#include "CommandUtility.h"
#include "Utility.h"
#include <nw/g3d/res/g3d_ResUtility.h>
#include <nn/nn_Assert.h>

using namespace System;
using namespace msclr::interop;
using namespace nw::g3d::edit::detail;
using namespace NintendoWare::G3d::Edit;

namespace NintendoWare { namespace G3d { namespace Edit {

size_t TextureCommandMaker::CalcTextureBindingPacketSize(array<UInt32>^ textureKeys)
{
    G3D_HTC_REQUIRES_NOT_NULL(textureKeys);

    size_t textureKeySize = textureKeys->Length * sizeof(u32);
    size_t size = CommandUtility::GetPacketHeaderSize() + sizeof(nn::g3d::viewer::detail::TextureBindingBlock) + textureKeySize;
    size_t totalSize = nn::util::align_up(size, nn::g3d::detail::Alignment_Default);
    return totalSize;
}

bool TextureCommandMaker::MakeBindTexturesPacket(
    array<Byte>^ packetBuffer,
    nn::g3d::viewer::detail::CommandFlag command,
    UInt32 targetKey,
    array<UInt32>^ textureKeys,
    TargetEndianKind endianKind)
{
    G3D_HTC_REQUIRES(endianKind == TargetEndianKind::LittleEndian, "Loading texture is unsupported for Cafe");
    G3D_HTC_REQUIRES_NOT_NULL(packetBuffer);
    G3D_HTC_REQUIRES_NOT_NULL(textureKeys);

    size_t totalSize = CalcTextureBindingPacketSize(textureKeys);
    if (packetBuffer->Length != totalSize)
    {
        return false;
    }

    pin_ptr<u8> pBuffer = &packetBuffer[0];

    nn::g3d::viewer::detail::TextureBindingPacket* pPacket = reinterpret_cast<nn::g3d::viewer::detail::TextureBindingPacket*>(pBuffer);
    pPacket->header = CommandUtility::GetNnG3dViewerPacketHeader();
    pPacket->header.command = command;
    pPacket->header.dataSize = static_cast<u32>(totalSize - CommandUtility::GetPacketHeaderSize());

    pPacket->block.bindTargetKey = targetKey;
    pPacket->block.textureKeyArrayCount = textureKeys->Length;

    for (u32 i = 0, end = pPacket->block.textureKeyArrayCount; i < end; ++i)
    {
        pPacket->block.textureKeyArrayData[i] = textureKeys[i];
    }

    // pin_ptr 解除
    pBuffer = nullptr;
    return true;
}

}}} // namespace NintendoWare.G3d.Edit
