﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// g3dhiolib.h

#pragma once

#include "G3dHioLibDefs.h"

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class RenderInfoCommandMaker abstract sealed
{
public:
    static int CalcSetupRenderInfoSize(array<IRenderInfo^>^ renderInfoArray);
    static int CalcQueryRenderInfoPacketSize(array<INT32>^ indices, array<IRenderInfo^>^ renderInfoArray);
    static int CalcSelectRenderInfoItemPacketSize(System::String^ labelName);

    static int CalcRenderInfoDicSize(array<IRenderInfo^>^ renderInfoArray);
    static int CalcUpdateRenderInfoPacketSize(array<IRenderInfo^>^ renderInfoArray);

    static bool MakeQueryRenderInfoPacket(
        array<System::Byte>^ packetBuffer,
        UINT32 key,
        array<INT32>^ indices,
        array<IRenderInfo^>^ renderInfoArray,
        NintendoWare::G3d::Edit::TargetEndianKind endianKind);

    static bool MakeEditStringRenderInfoPacket(
        array<System::Byte>^ packetBuffer,
        UINT32 modelObjKey,
        INT32 materialIndex,
        System::String^ labelName,
        NintendoWare::G3d::Edit::TargetEndianKind endianKind);

    static bool MakeEditIntRenderInfoPacket(
        array<System::Byte>^ packetBuffer,
        UINT32 modelObjKey,
        INT32 materialIndex,
        System::String^ labelName,
        INT32 slotIndex,
        INT32 value,
        NintendoWare::G3d::Edit::TargetEndianKind endianKind);

    static bool MakeEditFloatRenderInfoPacket(
        array<System::Byte>^ packetBuffer,
        UINT32 modelObjKey,
        INT32 materialIndex,
        System::String^ labelName,
        INT32 slotIndex,
        float value,
        NintendoWare::G3d::Edit::TargetEndianKind endianKind);

    static bool MakeUpdateRenderInfoPacket(
        array<System::Byte>^ packetBuffer,
        UINT32 modelObjKey,
        INT32 materialIndex,
        array<IRenderInfo^>^ renderInfoArray,
        NintendoWare::G3d::Edit::TargetEndianKind endianKind);
};

}}} // namespace NintendoWare.G3d.Edit
