﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "G3dHioLibDefs.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Diagnostics;
using namespace System::Collections::Generic;

#include <nw/g3d/edit/g3d_EditDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class QueryRenderInfoCommand : public EditIndicesModelCommand
{
public:
    QueryRenderInfoCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, array<INT32>^ materialIndices, array<IRenderInfo^>^ renderInfoArray)
        : EditIndicesModelCommand(targetEndian, target, materialIndices)
    {
        m_RenderInfoList = gcnew List<IRenderInfo^>();
        if (renderInfoArray == nullptr)
        {
            return;
        }

        for each (IRenderInfo^ renderInfo in renderInfoArray)
        {
            m_RenderInfoList->Add(dynamic_cast<IRenderInfo^>(renderInfo->Clone()));
        }
    }

    virtual bool MakeCommandPacket() override;

private:
    initonly List<IRenderInfo^>^ m_RenderInfoList;
};

private ref class EditStringRenderInfoCommand : public EditModelCommand
{
public:
    EditStringRenderInfoCommand(
        TargetEndianKind targetEndian,
        IEditModelTarget^ target,
        INT32 materialIndex,
        String^ labelName)
        : EditModelCommand(targetEndian, target)
    {
        m_MaterialIndex = materialIndex;
        m_LabelName = dynamic_cast<String^>(labelName->Clone());
    }

    virtual bool MakeCommandPacket() override;

private:
    INT32 m_MaterialIndex;
    String^ m_LabelName;
};

private ref class EditIntRenderInfoCommand : public EditModelCommand
{
public:
    EditIntRenderInfoCommand(
        TargetEndianKind targetEndian,
        IEditModelTarget^ target,
        INT32 materialIndex,
        String^ labelName,
        INT32 slotIndex,
        INT32 value)
        : EditModelCommand(targetEndian, target)
    {
        m_MaterialIndex = materialIndex;
        m_LabelName = dynamic_cast<String^>(labelName->Clone());
        m_SlotIndex = slotIndex;
        m_Value = value;
    }

    virtual bool MakeCommandPacket() override;
private:
    INT32 m_MaterialIndex;
    String^ m_LabelName;
    INT32 m_SlotIndex;
    INT32 m_Value;
};

private ref class EditFloatRenderInfoCommand : public EditModelCommand
{
public:
    EditFloatRenderInfoCommand(
        TargetEndianKind targetEndian,
        IEditModelTarget^ target,
        INT32 materialIndex,
        String^ labelName,
        INT32 slotIndex,
        float value)
        : EditModelCommand(targetEndian, target)
    {
        m_MaterialIndex = materialIndex;
        m_LabelName = dynamic_cast<String^>(labelName->Clone());
        m_SlotIndex = slotIndex;
        m_Value = value;
    }

    virtual bool MakeCommandPacket() override;
private:
    INT32 m_MaterialIndex;
    String^ m_LabelName;
    INT32 m_SlotIndex;
    float m_Value;
};

private ref class UpdateRenderInfoCommand : public EditModelCommand
{
public:
    UpdateRenderInfoCommand(
        TargetEndianKind targetEndian,
        IEditModelTarget^ target,
        INT32 materialIndex,
        array<IRenderInfo^>^ renderInfoArray)
        : EditModelCommand(targetEndian, target)
    {
        m_MaterialIndex = materialIndex;
        m_RenderInfoList = gcnew List<IRenderInfo^>();

        if (renderInfoArray == nullptr)
        {
            return;
        }

        for each (IRenderInfo^ renderInfo in renderInfoArray)
        {
            m_RenderInfoList->Add(dynamic_cast<IRenderInfo^>(renderInfo->Clone()));
        }
    }

    virtual bool MakeCommandPacket() override;
private:
    INT32 m_MaterialIndex;
    initonly List<IRenderInfo^>^ m_RenderInfoList;
};

}}} // namespace NintendoWare.G3d.Edit
