﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Diagnostics;
using namespace System::Collections::Generic;

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/g3d_EditDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class QueryModelLayoutCommand : public EditModelCommand
{
public:
    QueryModelLayoutCommand(TargetEndianKind targetEndian, IEditModelTarget^ target)
        : EditModelCommand(targetEndian, target)
    {
    }

    virtual bool MakeCommandPacket() override;
};

private ref class EditModelLayoutCommand : public EditModelCommand
{
public:
    EditModelLayoutCommand(
        TargetEndianKind targetEndian,
        IEditModelTarget^ target,
        bool isBind,
        Math::Vector3^ scale,
        Math::Vector3^ rotate,
        Math::Vector3^ translate)
        : EditModelCommand(targetEndian, target)
    {
        m_IsBind = isBind;
        m_Scale = gcnew Math::Vector3(scale->X, scale->Y, scale->Z);
        m_Rotate = gcnew Math::Vector3(rotate->X, rotate->Y, rotate->Z);
        m_Translate = gcnew Math::Vector3(translate->X, translate->Y, translate->Z);
    }

    virtual bool MakeCommandPacket() override;
private:
    bool m_IsBind;
    Math::Vector3^ m_Scale;
    Math::Vector3^ m_Rotate;
    Math::Vector3^ m_Translate;
};

private ref class EditBoneBindCommand : public EditModelCommand
{
public:
    EditBoneBindCommand(
        TargetEndianKind targetEndian,
        IEditModelTarget^ target,
        IEditModelTarget^ parentModel,
        INT32 parentBoneIndex)
        : EditModelCommand(targetEndian, target)
    {
        m_ParentModel = parentModel;
        m_ParentBoneIndex = parentBoneIndex;
    }

    virtual bool MakeCommandPacket() override;
protected:
    virtual bool CanProcessImpl() override
    {
        bool result = false;
        if (Target->ModelObjKey > 0)
        {
            if (m_ParentModel == nullptr)
            {
                result = true;
            }
            else
            {
                if (m_ParentModel->ModelObjKey > 0)
                {
                    result = true;
                }
            }
        }
        return result;
    }
private:
    IEditModelTarget^ m_ParentModel;
    INT32 m_ParentBoneIndex;
};

private ref class EditShapeLodLevelCommand : public EditModelCommand
{
public:
    EditShapeLodLevelCommand(
        TargetEndianKind targetEndian,
        IEditModelTarget^ target,
        INT32 level)
        : EditModelCommand(targetEndian, target)
    {
        m_LodLevel = level;
    }

    virtual bool MakeCommandPacket() override;

private:
    INT32 m_LodLevel;
};

}}} // namespace NintendoWare.G3d.Edit
