﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "LoadShaderCommand.h"
#include "CommandMaker.h"
#include "Utility.h"

using namespace nw::g3d::edit::detail;

namespace NintendoWare {
namespace G3d {
namespace Edit {

bool SendAttachShaderDefineCommand::MakeCommandPacket()
{
    // fsdb をランタイムに送る必要がなくなったのでファイルパスには空文字を入れておく
    System::String^ fsdbPath = System::String::Empty;
    int packetSize = CommandMaker::CalcFileDataPacketSize(fsdbPath);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    FileData^ fileData = gcnew FileData();
    fileData->Alignment = 1;
    fileData->FileName = fsdbPath;

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        EDIT_RECV_ATTACH_COMMAND_FLAG,
        nw::g3d::edit::detail::FILEDATA_SHADER_DEFINE,
        Target->ShaderArchiveKey,
        0,
        fileData,
        TargetEndian);
}

bool UnloadShaderArchiveCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(String::Empty);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    FileData^ fileData = gcnew FileData();
    fileData->Alignment = 0;
    fileData->FileName = String::Empty;

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        FILEDATA_UNLOAD_FILE_COMMAND_FLAG,
        nw::g3d::edit::detail::FILEDATA_SHADER_ARCHIVE,
        m_ReservedShaderArchiveKey,
        0,
        fileData,
        TargetEndian);
}

bool ReloadShaderDefineCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(m_FileName);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    FileData^ fileData = gcnew FileData();
    fileData->Alignment = 1;
    fileData->FileName = m_FileName;

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        FILEDATA_RELOAD_FILE_COMMAND_FLAG,
        nw::g3d::edit::detail::FILEDATA_SHADER_DEFINE,
        Target->ShaderArchiveKey,
        0,
        fileData,
        TargetEndian);
}



bool ReloadShaderProgramCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(m_FileName);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    FileData^ fileData = gcnew FileData();
    fileData->Alignment = 1;
    fileData->FileName = m_FileName;

    size_t alignment;
    NintendoWare::G3d::Edit::ReadResShaderFileAlignment(&alignment, m_FileName);
    fileData->Alignment = static_cast<uint>(alignment);

    bool result = CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        EDIT_RECV_MODIFIED_SHADER_COMMAND_FLAG,
        nw::g3d::edit::detail::FILEDATA_SHADER_PROGRAM,
        Target->ShaderArchiveKey,
        0,
        fileData,
        TargetEndian);
    if (!result)
    {
        return false;
    }

    // MakeFileDataPacket が成功している前提で実行しているエラー処理は最低限
    return CommandMaker::OverwriteModifiedShaderProgramPart(
        PacketBuffer,
        m_ShadingModelIndex,
        m_ShaderProgramIndex,
        TargetEndian);
}

}}} // namespace NintendoWare.G3d.Edit
