﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "EditBinDictionary.h"
#include <algorithm>
#include <functional>
#include <string>

namespace nw { namespace g3d { namespace tool {

void EditBinDictionary::Build(Context& ctx, size_t dicSize)
{
    ctx.blocks.push_back(this);
    m_NameArray.resize(dicSize);
}

void EditBinDictionary::CalcSize()
{
    // 要素が無い場合は辞書自体を作らない。
    auto count = m_NameArray.size();
    if (count > 0)
    {
        size_t size = sizeof(ResDicType::DataType);
        size += sizeof(ResDicType::Node) * count;
        SetBlockSize(BIN_MAIN, size);
    }
}

void EditBinDictionary::Convert(const Context& ctx)
{
    auto count = m_NameArray.size();
    if (count == 0)
    {
        return;
    }

    ResDicType::DataType& dic = *GetPtr<ResDicType::DataType>(ctx.pBuf);
    dic.size = static_cast<u32>(GetBlockSize(BIN_MAIN));
    dic.numData = static_cast<s32>(count);

    ResDicType::Node* pNode = &dic.node[0];
    pNode->refBit = 0;
    pNode->idxLeft = 0;
    pNode->idxRight = 0;
    pNode->ofsName.set_ptr(nullptr);
    pNode->ofsData.set_ptr(nullptr);
    ++pNode;

    for (auto iter = m_NameArray.cbegin(); iter != m_NameArray.cend(); ++iter, ++pNode)
    {
        pNode->refBit = 0;
        pNode->idxLeft = 0;
        pNode->idxRight = 0;
        const std::string* pName = *iter;
        if (pName)
        {
            pNode->ofsName.set_ptr(ctx.pool.GetPtr(*pName));
        }
        else
        {
            pNode->ofsName.set_ptr(nullptr);
        }
        // ofsData は Data の親がセットする。
    }

    ResDicType* ptrDic =
        ResDicType::ResCast(GetPtr<ResDicType::DataType>(ctx.pBuf));

    ResDicType::BuildResult result = ptrDic->Build();
    if (result == ResDicType::ERR_NAME_DUPLICATION)
    {
        bool isContinue = true;
        const std::string* pName = NULL;
        for (auto iterLhs = m_NameArray.cbegin(); iterLhs != m_NameArray.cend() && isContinue; ++iterLhs)
        {
            const std::string* pNameLhs = *iterLhs;

            for (auto iterRhs = iterLhs + 1; iterRhs != m_NameArray.cend() && isContinue; ++iterRhs)
            {
                const std::string* pNameRhs = *iterRhs;

                if (*pNameLhs == *pNameRhs)
                {
                    pName = pNameLhs;
                    isContinue = false;
                }
            }
        }
    }
}

}}} // namespace nw::g3d::tool
