﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit.Math
{
    public sealed class Vector2 : Vector2Base<float>, IVector
    {
        /// <summary>
        /// デフォルトコンストラクタです。
        /// </summary>
        public Vector2()
        {
        }

        /// <summary>
        /// X,Y座標を指定の値に設定するコンストラクタです。
        /// </summary>
        /// <param name="x">X座標です。</param>
        /// <param name="y">Y座標です。</param>
        public Vector2(float x, float y)
        {
            this.Set(x, y);
        }

        /// <summary>
        /// 指定したインデックス位置の成分を取得、または設定します。
        /// </summary>
        /// <param name="i">インデックスです。</param>
        /// <returns>成分です。</returns>
        public float this[int i]
        {
            get
            {
                switch (i)
                {
                    case 0:
                        return this.X;
                    case 1:
                        return this.Y;
                    default:
                        throw new ArgumentOutOfRangeException();
                }
            }

            set
            {
                switch (i)
                {
                    case 0:
                        this.X = value;
                        break;
                    case 1:
                        this.Y = value;
                        break;
                    default:
                        throw new ArgumentOutOfRangeException();
                }
            }
        }

        /// <summary>
        /// X,Y座標を格納した配列を返します。
        /// </summary>
        /// <returns>X,Y座標の配列です。</returns>
        float[] IVector.ToArray()
        {
            return this.ToArray();
        }
    }

    public sealed class Vector2i : Vector2Base<int>
    {
    }

    public sealed class Vector2u : Vector2Base<uint>
    {
    }
    public sealed class Vector2b : Vector2Base<bool>
    {
    }
}
