﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit
{
    /// <summary>
    /// コマンド対象のエンディアン種別です。
    /// </summary>
    public enum TargetEndianKind
    {
        /// <summary>
        /// ビッグエンディアン
        /// </summary>
        BigEndian,

        /// <summary>
        /// リトルエンディアン
        /// </summary>
        LittleEndian,
    }

    public interface ICommand
    {
        /// <summary>
        /// コマンドが処理できるか判定します。
        /// </summary>
        bool CanProcess();

        /// <summary>
        /// コマンド対象のエンディアンを取得します。
        /// </summary>
        TargetEndianKind TargetEndian { get; }

        /// <summary>
        /// コマンドの試行回数を取得します。
        /// </summary>
        uint NumberOfTrials
        {
            get;
        }

        /// <summary>
        /// コマンド追加順である必要があるか判定します。
        /// </summary>
        bool IsInOrder { get; }

        /// <summary>
        /// コマンド削除時に実行されます。
        /// </summary>
        void OnRemoved();
    }

    public interface ICommandTransaction : IDisposable
    {
    }
}
