﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

namespace NintendoWare.G3d.Edit
{
    public class EditShaderCommand : EditCommand
    {
        private readonly IEditShaderArchiveTarget target;
        protected EditShaderCommand(TargetEndianKind targetEndian, IEditShaderArchiveTarget target)
            : base(targetEndian)
        {
            Debug.Assert(target != null, "Invalid argument.");
            this.target = target;
        }

        protected IEditShaderArchiveTarget Target
        {
            get
            {
                return this.target;
            }
        }

        protected override bool CanProcessImpl()
        {
            if (target.ShaderArchiveKey > 0)
            {
                return true;
            }
            return false;
        }
    }

    public abstract class EditIndicesShaderCommand : EditShaderCommand
    {
        private readonly int[] indices;
        protected EditIndicesShaderCommand(TargetEndianKind targetEndian, IEditShaderArchiveTarget target, int[] indices)
            : base(targetEndian, target)
        {
            Debug.Assert(indices != null, "Invalid argument.");
            this.indices = new int[indices.Length];
            indices.CopyTo(this.indices, 0);
        }

        protected override bool CanProcessImpl()
        {
            if (!base.CanProcessImpl())
            {
                return false;
            }

            foreach (var index in this.indices)
            {
                if (index < 0)
                {
                    return false;
                }
            }
            return true;
        }

        protected int[] Indices
        {
            get
            {
                return this.indices;
            }
        }
    }
}
