﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

namespace NintendoWare.G3d.Edit
{
    public class EditAnimsCommand : EditCommand
    {
        private readonly List<IEditTarget> animations = new List<IEditTarget>();

        protected EditAnimsCommand(TargetEndianKind targetEndian, IEditTarget[] animations)
            : base(targetEndian)
        {
            this.animations.AddRange(animations);
        }

        protected IList<IEditTarget> Animations
        {
            get
            {
                return this.animations;
            }
        }

        protected override bool CanProcessImpl()
        {
            foreach (var anim in this.animations)
            {
                if (anim.ResFileKey <= 0)
                {
                    return false;
                }
            }

            return true;
        }
    }
}
