﻿using System;
using System.Globalization;
using System.Windows.Data;

namespace Nintendo.InGameEditing.WPF
{
    internal class StringToVisibilityConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string text = value as string;

            if (string.IsNullOrEmpty(text))
            {
                return System.Windows.Visibility.Collapsed;
            }

            return System.Windows.Visibility.Visible;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotSupportedException();
        }
    }
}
