﻿using System.Collections.Generic;

namespace Nintendo.InGameEditing.UI
{
    /// <summary>
    /// グループボックスコントロールです。
    /// </summary>
    public sealed class GroupBoxModel : ControlModel, IHasChildren
    {
        internal static readonly string UiType = "GroupBox";

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="node">元になるノード</param>
        /// <param name="attrs">メタデータに指定された属性の辞書</param>
        internal GroupBoxModel(Node node, Dictionary<string, string> attrs) : base(node, attrs)
        {
            Children = new ControlModelList(node.Children);
        }

        /// <summary>
        /// グループボックス内に含まれる子要素のリストを取得します。
        /// </summary>
        public ControlModelList Children { get; }
    }
}
