﻿using System;

namespace Nintendo.InGameEditing
{
    public static class TypeSerializer
    {
        /// <summary>
        /// 関数から ITypeSerializer&lt;T&gt; を作成します。
        /// </summary>
        /// <typeparam name="T">対象の型</typeparam>
        /// <param name="serialize">シリアライズ関数</param>
        /// <param name="deserialize">デシリアライズ関数</param>
        /// <returns>ITypeSerializer&lt;T&gt; インスタンス</returns>
        public static ITypeSerializer<T> Create<T>(Func<T, byte[]> serialize, Func<byte[], T> deserialize)
            => new AnonymousTypeSerializer<T>(serialize, deserialize);
    }

    internal class AnonymousTypeSerializer<T> : ITypeSerializer<T>
    {
        private static readonly byte[] EmptyBytes = new byte[0];
        private readonly Func<T, byte[]> serialize;
        private readonly Func<byte[], T> deserialize;

        internal AnonymousTypeSerializer(Func<T, byte[]> serialize, Func<byte[], T> deserialize)
        {
            if (serialize == null) { throw new ArgumentNullException(nameof(serialize)); }
            if (deserialize == null) { throw new ArgumentNullException(nameof(deserialize)); }

            this.serialize = serialize;
            this.deserialize = deserialize;
        }

        public byte[] Serialize(T value) => serialize(value) ?? EmptyBytes;

        public T Deserialize(byte[] data) => deserialize(data ?? EmptyBytes);
    }
}
