﻿using System;

namespace Nintendo.InGameEditing
{
    /// <summary>
    /// 型名に対する処理の解決を行うプロバイダのインターフェースです。
    /// </summary>
    public interface ITypeSerializerProvider
    {
        /// <summary>
        /// 型名から Type インスタンスへの解決を試みます。
        /// </summary>
        /// <param name="typeName">型名</param>
        /// <param name="targetType">サポートする型。サポートする場合、null を設定してはいけません。</param>
        /// <returns>その名前の型をサポートするかどうか</returns>
        bool TryResolveTypeName(string typeName, out Type targetType);

        /// <summary>
        /// 対応する型引数の ITypeSerializer`1 インスタンスの取得を試みます。
        /// </summary>
        /// <typeparam name="T">対象の型</typeparam>
        /// <param name="typeName">対象の型名</param>
        /// <param name="serializer">シリアライザーインスタンス</param>
        /// <returns>インスタンスの取得ができたかどうか</returns>
        bool TryGetTypeSerializer<T>(string typeName, out ITypeSerializer<T> serializer);

        /// <summary>
        /// 対応する型引数の ITypeSerializer`1 インスタンスの取得を試みます。
        /// </summary>
        /// <typeparam name="T">対象の型</typeparam>
        /// <param name="typeName">対象の型名</param>
        /// <param name="serializer">シリアライザーインスタンス</param>
        /// <returns>インスタンスの取得ができたかどうか</returns>
        bool TryGetArrayTypeSerializer<T>(string typeName, out ITypeSerializer<T[]> serializer);
    }
}
